/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.minecraft.control;

import binnie.core.craftgui.Attribute;
import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.geometry.Area;
import binnie.core.craftgui.geometry.Border;
import binnie.core.craftgui.geometry.Point;
import binnie.core.craftgui.geometry.Position;
import binnie.core.craftgui.geometry.TextJustification;
import binnie.core.craftgui.renderer.RenderUtil;
import binnie.core.craftgui.resource.Texture;
import binnie.core.craftgui.resource.minecraft.CraftGUITexture;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlSlide
extends Control {
    private Area expanded;
    private Area shrunk;
    private boolean slideActive = true;
    private Position anchor;
    private String label = null;

    public ControlSlide(IWidget parent, int x, int y, int w, int h, Position anchor2) {
        super(parent, x, y, w, h);
        this.addAttribute(Attribute.MouseOver);
        this.addAttribute(Attribute.BlockTooltip);
        this.expanded = new Area(this.getPosition(), this.getSize());
        this.anchor = anchor2.opposite();
        int border = this.anchor.x() != 0 ? this.expanded.width() - 6 : this.expanded.height() - 6;
        this.shrunk = this.expanded.inset(new Border(this.anchor, border));
        this.slideActive = false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        super.onRenderBackground(guiWidth, guiHeight);
        if (this.label != null) {
            int lw = RenderUtil.getTextWidth(this.label) + 16;
            int lh = RenderUtil.getTextHeight() + 16;
            boolean hor = this.anchor.x() != 0;
            Area ar = this.isSlideActive() ? this.expanded : this.shrunk;
            Area tabArea = new Area(hor ? -lh / 2 : -lw / 2, hor ? -lw / 2 : -lh / 2, hor ? lh : lw, hor ? lw : lh);
            Point shift = new Point(ar.width() * (1 - this.anchor.x()) / 2, ar.height() * (1 - this.anchor.y()) / 2);
            tabArea = tabArea.shift(shift.x() - (-3 + lh / 2) * this.anchor.x(), shift.y() - (-3 + lh / 2) * this.anchor.y());
            Texture texture = CraftGUI.render.getTexture((Object)(this.isSlideActive() ? CraftGUITexture.Tab : CraftGUITexture.TabDisabled)).crop(this.anchor.opposite(), 8);
            CraftGUI.render.texture(texture, tabArea);
            texture = CraftGUI.render.getTexture((Object)CraftGUITexture.TabOutline).crop(this.anchor.opposite(), 8);
            CraftGUI.render.texture(texture, tabArea.inset(2));
            Area labelArea = new Area(-lw / 2, 0, lw, lh);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(shift.x() + this.anchor.x() * 2), (float)(shift.y() + this.anchor.y() * 2), (float)0.0f);
            if (this.anchor.x() != 0) {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)this.anchor.x());
            }
            if (this.anchor.y() > 0) {
                GlStateManager.func_179109_b((float)0.0f, (float)(-lh), (float)0.0f);
            }
            RenderUtil.drawText(labelArea, TextJustification.MIDDLE_CENTER, this.label, 0xFFFFFF);
            GlStateManager.func_179121_F();
        }
        CraftGUI.render.texture((Object)CraftGUITexture.Window, this.getArea());
        CraftGUITexture slideTexture = this.anchor == Position.BOTTOM ? CraftGUITexture.SlideDown : (this.anchor == Position.Top ? CraftGUITexture.SlideUp : (this.anchor == Position.LEFT ? CraftGUITexture.SlideLeft : CraftGUITexture.SlideRight));
        CraftGUI.render.texture((Object)slideTexture, new Point((this.anchor.x() + 1) * this.width() / 2 - 8, (this.anchor.y() + 1) * this.height() / 2 - 8));
    }

    public boolean isSlideActive() {
        return this.slideActive;
    }

    @Override
    public void onUpdateClient() {
        boolean mouseOver = this.isMouseOverWidget(this.getRelativeMousePosition());
        if (mouseOver != this.slideActive) {
            this.setSlide(mouseOver);
        }
    }

    @Override
    public boolean isMouseOverWidget(Point relativeMouse) {
        return this.getArea().outset(this.isSlideActive() ? 16 : 8).outset(new Border(this.anchor.opposite(), 16)).contains(relativeMouse);
    }

    @Override
    public boolean isChildVisible(IWidget child) {
        return this.slideActive;
    }

    public void setSlide(boolean b) {
        this.slideActive = b;
        Area area = this.isSlideActive() ? this.expanded : this.shrunk;
        this.setSize(area.size());
        this.setPosition(area.pos());
    }

    public void setLabel(String l) {
        this.label = l;
    }
}

