/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.database;

import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.ControlTextCentered;
import binnie.core.craftgui.controls.page.ControlPage;
import binnie.core.craftgui.database.ControlBreedingProgress;
import binnie.core.craftgui.database.DatabaseTab;
import binnie.core.craftgui.database.WindowAbstractDatabase;
import binnie.core.craftgui.minecraft.Window;
import binnie.core.genetics.BreedingSystem;
import binnie.core.util.I18N;
import com.mojang.authlib.GameProfile;
import net.minecraft.util.text.TextFormatting;

public class PageBreeder
extends ControlPage<DatabaseTab> {
    private GameProfile player;

    public PageBreeder(IWidget parent, GameProfile player, DatabaseTab tab) {
        super(parent, 0, 0, parent.getSize().x(), parent.getSize().y(), tab);
        this.player = player;
        this.onPageRefresh();
    }

    public void onPageRefresh() {
        while (this.getWidgets().size() > 0) {
            this.deleteChild(this.getWidgets().get(0));
        }
        BreedingSystem system = ((WindowAbstractDatabase)Window.get(this)).getBreedingSystem();
        String descriptor = system.getDescriptor();
        new ControlTextCentered((IWidget)this, 8, TextFormatting.UNDERLINE + system.getDescriptor() + " " + I18N.localise("binniecore.gui.database.breeder.profile"));
        new ControlTextCentered((IWidget)this, 75, "" + system.discoveredSpeciesCount + "/" + system.totalSpeciesCount + " " + I18N.localise("binniecore.gui.database.species"));
        new ControlBreedingProgress(this, 20, 87, 102, 14, system, system.discoveredSpeciesPercentage);
        new ControlTextCentered((IWidget)this, 115, "" + system.discoveredBranchCount + "/" + system.totalBranchCount + " " + I18N.localise("binniecore.gui.database.breeder.branches"));
        new ControlBreedingProgress(this, 20, 127, 102, 14, system, system.discoveredBranchPercentage);
        if (system.discoveredSecretCount > 0) {
            new ControlTextCentered((IWidget)this, 155, "" + system.discoveredSecretCount + "/" + system.totalSecretCount + " " + I18N.localise("binniecore.gui.database.breeder.species.secret"));
        }
        new ControlTextCentered((IWidget)this, 32, this.player.getName());
        new ControlTextCentered((IWidget)this, 44, TextFormatting.ITALIC + system.getEpitome());
    }
}

