/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.controls.listbox;

import binnie.core.craftgui.Attribute;
import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.controls.core.IControlValue;
import binnie.core.craftgui.controls.listbox.ControlList;
import binnie.core.craftgui.events.EventMouse;
import binnie.core.craftgui.resource.minecraft.CraftGUITexture;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlOption<T>
extends Control
implements IControlValue<T> {
    private T value;

    public ControlOption(ControlList<T> controlList, T option) {
        this(controlList, option, 16);
    }

    public ControlOption(final ControlList<T> controlList, T option, int height) {
        super(controlList, 0, height, controlList.getSize().x(), 20);
        this.value = option;
        this.addAttribute(Attribute.MouseOver);
        this.addSelfEventHandler(new EventMouse.Down.Handler(){

            @Override
            public void onEvent(EventMouse.Down event) {
                controlList.setValue(ControlOption.this.getValue());
            }
        });
    }

    @Override
    public void onUpdateClient() {
        int colour = 0xA0A0A0;
        if (this.isCurrentSelection()) {
            colour = 0xFFFFFF;
        }
        this.setColor(colour);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
    }

    public boolean isCurrentSelection() {
        return this.getValue().equals(((IControlValue)this.getParent()).getValue());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderForeground(int guiWidth, int guiHeight) {
        if (this.isCurrentSelection()) {
            CraftGUI.render.texture((Object)CraftGUITexture.Outline, this.getArea());
        }
    }
}

