/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui;

import binnie.core.craftgui.ITopLevelWidget;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.Widget;
import binnie.core.craftgui.events.EventMouse;
import binnie.core.craftgui.events.EventWidget;
import binnie.core.craftgui.geometry.Area;
import binnie.core.craftgui.geometry.Point;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.ListIterator;
import javax.annotation.Nullable;
import org.lwjgl.input.Mouse;

public abstract class TopLevelWidget
extends Widget
implements ITopLevelWidget {
    protected Point mousePosition = Point.ZERO;
    @Nullable
    IWidget mousedOverWidget = null;
    @Nullable
    IWidget draggedWidget = null;
    @Nullable
    IWidget focusedWidget = null;
    Point dragStart = Point.ZERO;

    public TopLevelWidget() {
        super(null);
        this.addEventHandler(new EventMouse.Down.Handler(){

            @Override
            public void onEvent(EventMouse.Down event) {
                TopLevelWidget.this.setDraggedWidget(TopLevelWidget.this.mousedOverWidget, event.getButton());
                TopLevelWidget.this.setFocusedWidget(TopLevelWidget.this.mousedOverWidget);
            }
        });
        this.addEventHandler(new EventMouse.Up.Handler(){

            @Override
            public void onEvent(EventMouse.Up event) {
                TopLevelWidget.this.setDraggedWidget(null);
            }
        });
        this.addEventHandler(new EventWidget.StartDrag.Handler(){

            @Override
            public void onEvent(EventWidget.StartDrag event) {
                TopLevelWidget.this.dragStart = TopLevelWidget.this.getRelativeMousePosition();
            }
        });
    }

    public void setDraggedWidget(@Nullable IWidget widget, int button) {
        if (this.draggedWidget == widget) {
            return;
        }
        if (this.draggedWidget != null) {
            this.callEvent(new EventWidget.EndDrag(this.draggedWidget));
        }
        this.draggedWidget = widget;
        if (this.draggedWidget != null) {
            this.callEvent(new EventWidget.StartDrag(this.draggedWidget, button));
        }
    }

    @Override
    @Nullable
    public IWidget getMousedOverWidget() {
        return this.mousedOverWidget;
    }

    public void setMousedOverWidget(@Nullable IWidget widget) {
        if (this.mousedOverWidget == widget) {
            return;
        }
        if (this.mousedOverWidget != null) {
            this.callEvent(new EventWidget.EndMouseOver(this.mousedOverWidget));
        }
        this.mousedOverWidget = widget;
        if (this.mousedOverWidget != null) {
            this.callEvent(new EventWidget.StartMouseOver(this.mousedOverWidget));
        }
    }

    @Override
    @Nullable
    public IWidget getDraggedWidget() {
        return this.draggedWidget;
    }

    public void setDraggedWidget(@Nullable IWidget widget) {
        this.setDraggedWidget(widget, -1);
    }

    @Override
    @Nullable
    public IWidget getFocusedWidget() {
        return this.focusedWidget;
    }

    public void setFocusedWidget(@Nullable IWidget widget) {
        IWidget newWidget = widget;
        if (this.focusedWidget == newWidget) {
            return;
        }
        if (newWidget != null && !newWidget.canFocus()) {
            newWidget = null;
        }
        if (this.focusedWidget != null) {
            this.callEvent(new EventWidget.LoseFocus(this.focusedWidget));
        }
        this.focusedWidget = newWidget;
        if (this.focusedWidget != null) {
            this.callEvent(new EventWidget.GainFocus(this.focusedWidget));
        }
    }

    @Override
    public boolean isMouseOver(IWidget widget) {
        return this.getMousedOverWidget() == widget;
    }

    @Override
    public boolean isDragged(IWidget widget) {
        return this.getDraggedWidget() == widget;
    }

    @Override
    public boolean isFocused(IWidget widget) {
        return this.getFocusedWidget() == widget;
    }

    @Override
    public void updateTopLevel() {
        this.setMousedOverWidget(this.calculateMousedOverWidget());
        if (!(this.getFocusedWidget() == null || this.getFocusedWidget().isVisible() && this.getFocusedWidget().isEnabled())) {
            this.setFocusedWidget(null);
        }
        if (!Mouse.isButtonDown((int)0) && this.draggedWidget != null) {
            this.setDraggedWidget(null);
        }
    }

    @Nullable
    private IWidget calculateMousedOverWidget() {
        Deque<IWidget> queue = this.calculateMousedOverWidgets();
        while (!queue.isEmpty()) {
            IWidget widget = queue.removeFirst();
            if (!widget.isEnabled() || !widget.isVisible() || !widget.canMouseOver() || !widget.calculateIsMouseOver()) continue;
            return widget;
        }
        return null;
    }

    public Deque<IWidget> calculateMousedOverWidgets() {
        ArrayDeque<IWidget> list = new ArrayDeque<IWidget>();
        for (IWidget widget : this.getQueuedWidgets(this)) {
            if (!widget.calculateIsMouseOver()) continue;
            list.addLast(widget);
        }
        return list;
    }

    private Collection<IWidget> getQueuedWidgets(IWidget widget) {
        ArrayList<IWidget> widgets = new ArrayList<IWidget>();
        boolean addChildren = true;
        Area croppedZone = widget.getCroppedZone();
        if (croppedZone != null) {
            addChildren = croppedZone.contains(widget.getCropWidget().getRelativeMousePosition());
        }
        if (addChildren) {
            ListIterator<IWidget> li = widget.getWidgets().listIterator(widget.getWidgets().size());
            while (li.hasPrevious()) {
                IWidget child = li.previous();
                widgets.addAll(this.getQueuedWidgets(child));
            }
        }
        widgets.add(widget);
        return widgets;
    }

    @Override
    public void setMousePosition(int x, int y) {
        float dx = x - this.mousePosition.x();
        float dy = y - this.mousePosition.y();
        if (dx != 0.0f || dy != 0.0f) {
            if (this.getDraggedWidget() != null) {
                this.callEvent(new EventMouse.Drag(this.getDraggedWidget(), dx, dy));
            } else {
                this.callEvent(new EventMouse.Move(this, dx, dy));
            }
        }
        if (this.mousePosition.x() != x || this.mousePosition.y() != y) {
            this.mousePosition = new Point(x, y);
            this.setMousedOverWidget(this.calculateMousedOverWidget());
        }
    }

    @Override
    public Point getAbsoluteMousePosition() {
        return this.mousePosition;
    }

    @Override
    public void widgetDeleted(IWidget widget) {
        if (this.isMouseOver(widget)) {
            this.setMousedOverWidget(null);
        }
        if (this.isDragged(widget)) {
            this.setDraggedWidget(null);
        }
        if (this.isFocused(widget)) {
            this.setFocusedWidget(null);
        }
    }

    @Override
    public Point getDragDistance() {
        return this.getRelativeMousePosition().sub(this.dragStart);
    }
}

