/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.gardening;

import binnie.botany.Botany;
import binnie.botany.api.EnumAcidity;
import binnie.botany.api.EnumMoisture;
import binnie.botany.api.EnumSoilType;
import binnie.botany.api.IBlockSoil;
import binnie.botany.api.IFlower;
import binnie.botany.api.IGardeningManager;
import binnie.botany.gardening.BlockPlant;
import binnie.botany.gardening.ModuleGardening;
import binnie.botany.items.BotanyItems;
import forestry.api.climate.IClimateInfo;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class Gardening
implements IGardeningManager {
    private final Map<ItemStack, Integer> fertiliserAcid = new LinkedHashMap<ItemStack, Integer>();
    private final Map<ItemStack, Integer> fertiliserAlkaline = new LinkedHashMap<ItemStack, Integer>();
    private final Map<ItemStack, Integer> fertiliserNutrient = new LinkedHashMap<ItemStack, Integer>();

    @Override
    public boolean isSoil(Block block) {
        return block instanceof IBlockSoil;
    }

    @Override
    public boolean isSoil(Item item) {
        return item instanceof ItemBlock && this.isSoil(((ItemBlock)item).func_179223_d());
    }

    @Override
    public boolean isSoil(ItemStack item) {
        return this.isSoil(item.func_77973_b());
    }

    @Override
    public EnumMoisture getNaturalMoisture(World world, BlockPos pos) {
        int dz;
        int dx;
        float bias = this.getBiomeMoisture(world, pos);
        for (dx = -1; dx < 2; ++dx) {
            for (dz = -1; dz < 2; ++dz) {
                if (dx == 0 && dz == 0) continue;
                if (world.func_180495_p(pos.func_177982_a(dx, 0, dz)) == Blocks.field_150354_m) {
                    bias = (float)((double)bias - 1.5);
                    continue;
                }
                if (world.func_180495_p(pos.func_177982_a(dx, 0, dz)) != Blocks.field_150355_j) continue;
                bias = (float)((double)bias + 1.5);
            }
        }
        if (world.func_72896_J() && world.func_175710_j(pos.func_177984_a()) && world.func_175725_q(pos).func_177956_o() <= pos.func_177956_o() + 1) {
            bias = (float)((double)bias + 1.5);
        }
        for (dx = -1; dx < 2; ++dx) {
            for (dz = -1; dz < 2; ++dz) {
                if (dx == 0 && dz == 0 || world.func_180495_p(pos.func_177982_a(dx, 0, dz)).func_177230_c() != Blocks.field_150351_n || !(bias > 0.0f)) continue;
                bias *= 0.4f;
            }
        }
        return bias <= -1.0f ? EnumMoisture.DRY : (bias >= 1.0f ? EnumMoisture.DAMP : EnumMoisture.NORMAL);
    }

    @Override
    public EnumAcidity getNaturalPH(World world, BlockPos pos) {
        float bias = this.getBiomePH(world, pos);
        if (bias <= -1.0f) {
            return EnumAcidity.ACID;
        }
        return bias >= 1.0f ? EnumAcidity.ALKALINE : EnumAcidity.NEUTRAL;
    }

    @Override
    public float getBiomeMoisture(World world, BlockPos pos) {
        double temperature;
        IClimateInfo info = ForestryAPI.climateManager.getInfo(world, pos);
        double humidity = info.getHumidity();
        double m = 3.2 * (humidity - 0.5) - 0.4 * (1.0 + (temperature = (double)info.getTemperature()) + 0.5 * temperature * temperature) + 1.1 - 1.6 * (temperature - 0.9) * (temperature - 0.9) - 0.002 * (double)(pos.func_177956_o() - 64);
        return (float)(m == 0.0 ? m : (m < 0.0 ? -Math.sqrt(m * m) : Math.sqrt(m * m)));
    }

    @Override
    public float getBiomePH(World world, BlockPos pos) {
        IClimateInfo info = ForestryAPI.climateManager.getInfo(world, pos);
        double humidity = info.getHumidity();
        double temperature = info.getTemperature();
        return (float)(-3.0 * (humidity - 0.5) + 0.5 * (temperature - (double)0.7f) * (temperature - (double)0.7f) + (double)(0.02f * (float)(pos.func_177956_o() - 64)) - (double)0.15f);
    }

    @Override
    public void plantSoil(World world, BlockPos pos, EnumSoilType soil, EnumMoisture moisture, EnumAcidity acidity) {
        int meta = moisture.ordinal() + acidity.ordinal() * 3;
        world.func_180501_a(pos, this.getSoilBlock(soil).func_176203_a(meta), 2);
    }

    @Override
    public Collection<ItemStack> getAcidFertilisers() {
        return Collections.unmodifiableSet(this.fertiliserAcid.keySet());
    }

    @Override
    public Collection<ItemStack> getAlkalineFertilisers() {
        return Collections.unmodifiableSet(this.fertiliserAlkaline.keySet());
    }

    @Override
    public Collection<ItemStack> getNutrientFertilisers() {
        return Collections.unmodifiableSet(this.fertiliserNutrient.keySet());
    }

    @Override
    public void registerAcidFertiliser(ItemStack stack, int strength) {
        ModuleGardening.queuedAcidFertilisers.put(stack, strength);
        this.fertiliserAcid.put(stack, strength);
    }

    @Override
    public void registerAlkalineFertiliser(ItemStack stack, int strength) {
        ModuleGardening.queuedAlkalineFertilisers.put(stack, strength);
        this.fertiliserAlkaline.put(stack, strength);
    }

    @Override
    public void registerNutrientFertiliser(ItemStack stack, int strength) {
        ModuleGardening.queuedNutrientFertilisers.put(stack, strength);
        this.fertiliserNutrient.put(stack, strength);
    }

    @Override
    public boolean isAcidFertiliser(ItemStack itemstack) {
        for (ItemStack stack : this.getAcidFertilisers()) {
            if (stack.func_190926_b() || !stack.func_77969_a(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAlkalineFertiliser(ItemStack itemstack) {
        for (ItemStack stack : this.getAlkalineFertilisers()) {
            if (stack.func_190926_b() || !stack.func_77969_a(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNutrientFertiliser(ItemStack itemstack) {
        for (ItemStack stack : this.getNutrientFertilisers()) {
            if (stack.func_190926_b() || !stack.func_77969_a(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getFertiliserStrength(ItemStack stack) {
        for (Map.Entry<ItemStack, Integer> entry : this.fertiliserAcid.entrySet()) {
            if (!entry.getKey().func_77969_a(stack)) continue;
            return entry.getValue();
        }
        for (Map.Entry<ItemStack, Integer> entry : this.fertiliserAlkaline.entrySet()) {
            if (!entry.getKey().func_77969_a(stack)) continue;
            return entry.getValue();
        }
        for (Map.Entry<ItemStack, Integer> entry : this.fertiliserNutrient.entrySet()) {
            if (!entry.getKey().func_77969_a(stack)) continue;
            return entry.getValue();
        }
        return 1;
    }

    @Override
    public boolean canTolerate(@Nullable IFlower flower, World world, BlockPos pos) {
        if (flower == null) {
            return false;
        }
        IBlockState soil = world.func_180495_p(pos.func_177977_b());
        Block soilBlock = soil.func_177230_c();
        int soilMeta = soilBlock.func_176201_c(soil);
        Biome biome = world.func_180494_b(pos);
        return this.canTolerate(flower, EnumAcidity.values()[soilMeta / 3 % 3], EnumMoisture.values()[soilMeta % 3], EnumTemperature.getFromValue((float)biome.func_185353_n()));
    }

    @Override
    public EnumSoilType getSoilType(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() instanceof IBlockSoil) {
            return ((IBlockSoil)world.func_180495_p(pos).func_177230_c()).getType(world, pos);
        }
        return EnumSoilType.SOIL;
    }

    @Override
    public Block getSoilBlock(EnumSoilType type) {
        return this.getSoilBlock(type, false);
    }

    @Override
    public Block getSoilBlock(EnumSoilType type, boolean weedKill) {
        switch (type) {
            case FLOWERBED: {
                return weedKill ? Botany.flowerbedNoWeed : Botany.flowerbed;
            }
            case LOAM: {
                return weedKill ? Botany.loamNoWeed : Botany.loam;
            }
        }
        return weedKill ? Botany.soilNoWeed : Botany.soil;
    }

    @Override
    public boolean canTolerate(IFlower flower, EnumAcidity acidity, EnumMoisture moisture, EnumTemperature temperature) {
        return flower.getGenome().canTolerate(acidity) && flower.getGenome().canTolerate(moisture) && flower.getGenome().canTolerate(temperature);
    }

    @Override
    public boolean isWeedkiller(ItemStack heldItem) {
        return heldItem.func_77969_a(BotanyItems.WEEDKILLER.get(1));
    }

    @Override
    public boolean addWeedKiller(World world, BlockPos pos) {
        IBlockState oldState;
        if (!(world.func_180495_p(pos).func_177230_c() instanceof IBlockSoil)) {
            return false;
        }
        EnumSoilType type = this.getSoilType(world, pos);
        Block block = this.getSoilBlock(type, true);
        IBlockState newState = block.func_176203_a((oldState = world.func_180495_p(pos)).func_177230_c().func_176201_c(oldState));
        boolean done = world.func_180501_a(pos, newState, 2);
        if (done && BlockPlant.isWeed((IBlockAccess)world, pos.func_177984_a())) {
            world.func_175698_g(pos.func_177984_a());
        }
        return done;
    }
}

