/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.flower;

import binnie.botany.CreativeTabBotany;
import binnie.botany.flower.EnumTubeInsulate;
import binnie.botany.flower.EnumTubeMaterial;
import binnie.core.item.ItemCore;
import binnie.core.util.I18N;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.core.IModelManager;
import forestry.core.circuits.SolderManager;
import forestry.core.items.IColoredItem;
import forestry.core.utils.Translator;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemInsulatedTube
extends ItemCore
implements IColoredItem {
    public ItemInsulatedTube() {
        super("insulated_tube");
        this.func_77655_b("botany.insulated_tube");
        this.func_77637_a(CreativeTabBotany.instance);
        this.func_77627_a(true);
    }

    private static Multimap<ICircuitLayout, ICircuit> getCircuits(ItemStack itemStack) {
        ArrayListMultimap circuits = ArrayListMultimap.create();
        Collection allLayouts = ChipsetManager.circuitRegistry.getRegisteredLayouts().values();
        for (ICircuitLayout circuitLayout : allLayouts) {
            ICircuit circuit = SolderManager.getCircuit((ICircuitLayout)circuitLayout, (ItemStack)itemStack);
            if (circuit == null) continue;
            circuits.put((Object)circuitLayout, (Object)circuit);
        }
        return circuits;
    }

    public static String getInsulate(ItemStack stack) {
        return EnumTubeInsulate.get(stack.func_77952_i()).getDisplayName();
    }

    public static ItemStack getInsulateStack(ItemStack stack) {
        return EnumTubeInsulate.get(stack.func_77952_i()).getStack();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        for (EnumTubeMaterial mat : EnumTubeMaterial.values()) {
            for (EnumTubeInsulate ins : EnumTubeInsulate.values()) {
                subItems.add((Object)new ItemStack((Item)this, 1, mat.ordinal() + ins.ordinal() * 128));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        for (EnumTubeMaterial mat : EnumTubeMaterial.values()) {
            for (EnumTubeInsulate ins : EnumTubeInsulate.values()) {
                manager.registerItemModel(item, mat.ordinal() + ins.ordinal() * 128);
            }
        }
    }

    public int getColorFromItemstack(ItemStack stack, int tintIndex) {
        if (tintIndex == 0) {
            return 0xFFFFFF;
        }
        if (tintIndex == 1) {
            return EnumTubeMaterial.get(stack.func_77952_i()).getColor();
        }
        return EnumTubeInsulate.get(stack.func_77952_i()).getColor();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List<String> list, boolean flag) {
        super.func_77624_a(itemstack, player, list, flag);
        Multimap<ICircuitLayout, ICircuit> circuits = ItemInsulatedTube.getCircuits(itemstack);
        if (!circuits.isEmpty()) {
            if (GuiScreen.func_146272_n()) {
                for (ICircuitLayout circuitLayout : circuits.keys()) {
                    String circuitLayoutName = circuitLayout.getUsage();
                    list.add(TextFormatting.WHITE.toString() + TextFormatting.UNDERLINE + circuitLayoutName);
                    for (ICircuit circuit : circuits.get((Object)circuitLayout)) {
                        circuit.addTooltip(list);
                    }
                }
            } else {
                list.add(TextFormatting.ITALIC + "<" + Translator.translateToLocal((String)"for.gui.tooltip.tmi") + ">");
            }
        } else {
            list.add("<" + Translator.translateToLocal((String)"for.gui.noeffect") + ">");
        }
    }

    public String func_77653_i(ItemStack itemStack) {
        int meta = itemStack.func_77960_j();
        return I18N.localise("item.botany.insulated_tube.name", EnumTubeMaterial.get(meta).getDisplayName(), EnumTubeInsulate.get(meta).getDisplayName());
    }
}

