/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.ceramic.brick;

import binnie.botany.Botany;
import binnie.botany.ceramic.brick.CeramicBrickType;
import binnie.botany.genetics.EnumFlowerColor;
import binnie.core.block.TileEntityMetadata;
import binnie.core.util.I18N;
import com.google.common.base.Preconditions;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CeramicBrickPair {
    public final EnumFlowerColor colorFirst;
    public final EnumFlowerColor colorSecond;
    public CeramicBrickType type;
    public int ordinal;

    CeramicBrickPair(EnumFlowerColor colorFirst, EnumFlowerColor colorSecond, CeramicBrickType type) {
        this.colorFirst = colorFirst;
        this.colorSecond = colorSecond;
        this.type = type;
        this.ordinal = colorFirst.ordinal() + colorSecond.ordinal() * 256 + type.ordinal() * 256 * 256;
    }

    public CeramicBrickPair(ItemStack stack) {
        this(TileEntityMetadata.getItemDamage(stack));
    }

    public CeramicBrickPair(int id) {
        this.colorFirst = EnumFlowerColor.get(id & 0xFF);
        this.colorSecond = EnumFlowerColor.get(id >> 8 & 0xFF);
        this.type = CeramicBrickType.get(id >> 16 & 0xFF);
    }

    public boolean isTwoColors() {
        return this.type.canDouble() && this.colorSecond != this.colorFirst;
    }

    public ItemStack getStack(int i) {
        return new ItemStack((Block)Botany.ceramicBrick, i, this.ordinal());
    }

    public String getName() {
        String name = this.colorFirst.getFlowerColorAllele().getColorName();
        if (this.type.canDouble() && this.colorSecond != this.colorFirst) {
            name = name + " & " + this.colorSecond.getFlowerColorAllele().getColorName();
        }
        return I18N.localise("botany.ceramic.type." + this.type.id + ".name", name);
    }

    public int ordinal() {
        return this.ordinal;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getSprite(int pass) {
        TextureAtlasSprite[] sprites = this.type.sprites;
        Preconditions.checkState((sprites != null ? 1 : 0) != 0, (Object)"Sprites have not been registered.");
        return sprites[pass];
    }

    public int hashCode() {
        return Integer.hashCode(this.ordinal());
    }

    public boolean equals(Object obj) {
        return obj instanceof CeramicBrickPair && ((CeramicBrickPair)obj).ordinal() == this.ordinal();
    }
}

