/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.api;

import binnie.botany.api.EnumAcidity;
import binnie.botany.api.EnumMoisture;
import binnie.botany.api.EnumSoilType;
import binnie.botany.api.IBlockSoil;
import binnie.botany.api.IFlower;
import forestry.api.core.EnumTemperature;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IGardeningManager {
    default public boolean isSoil(Block block) {
        return block instanceof IBlockSoil;
    }

    public boolean isSoil(Item var1);

    public boolean isSoil(ItemStack var1);

    public EnumMoisture getNaturalMoisture(World var1, BlockPos var2);

    public EnumAcidity getNaturalPH(World var1, BlockPos var2);

    public float getBiomeMoisture(World var1, BlockPos var2);

    public float getBiomePH(World var1, BlockPos var2);

    public void plantSoil(World var1, BlockPos var2, EnumSoilType var3, EnumMoisture var4, EnumAcidity var5);

    public Collection<ItemStack> getAcidFertilisers();

    public Collection<ItemStack> getAlkalineFertilisers();

    public Collection<ItemStack> getNutrientFertilisers();

    public void registerAcidFertiliser(ItemStack var1, int var2);

    public void registerAlkalineFertiliser(ItemStack var1, int var2);

    public void registerNutrientFertiliser(ItemStack var1, int var2);

    public boolean isAcidFertiliser(ItemStack var1);

    public boolean isAlkalineFertiliser(ItemStack var1);

    public boolean isNutrientFertiliser(ItemStack var1);

    public int getFertiliserStrength(ItemStack var1);

    public boolean canTolerate(@Nullable IFlower var1, World var2, BlockPos var3);

    public EnumSoilType getSoilType(World var1, BlockPos var2);

    default public Block getSoilBlock(EnumSoilType type) {
        return this.getSoilBlock(type, false);
    }

    public Block getSoilBlock(EnumSoilType var1, boolean var2);

    public boolean canTolerate(IFlower var1, EnumAcidity var2, EnumMoisture var3, EnumTemperature var4);

    public boolean isWeedkiller(ItemStack var1);

    public boolean addWeedKiller(World var1, BlockPos var2);
}

