/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.circuit;

import binnie.extrabees.circuit.StimulatorCircuit;
import binnie.extrabees.utils.BeeModifierLogic;
import binnie.extrabees.utils.EnumBeeBooleanModifier;
import binnie.extrabees.utils.EnumBeeModifier;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.circuits.ICircuitLayout;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum AlvearySimulatorCircuitType implements IBeeModifier
{
    LowVoltage(3, 10),
    HighVoltage(5, 20),
    Plant(10, 10),
    Death(6, 10),
    Life(11, 10),
    Nether(7, 15),
    Mutation(4, 15),
    Inhibitor(1, 10),
    Territory(2, 10);

    public int recipe;
    public int power;
    BeeModifierLogic logic = new BeeModifierLogic();

    private AlvearySimulatorCircuitType(int recipe, int power) {
        this.recipe = recipe;
        this.power = power;
    }

    public void createCircuit(ICircuitLayout layout) {
        StimulatorCircuit circuit = new StimulatorCircuit(this, layout);
        for (EnumBeeModifier modifier : EnumBeeModifier.values()) {
            float mod = this.logic.getModifier(modifier, 1.0f);
            if (mod == 1.0f) continue;
            if (mod > 1.0f) {
                int increase = (int)((mod - 1.0f) * 100.0f);
                circuit.addTooltip("Increases " + modifier.getName() + " by " + increase + "%");
                continue;
            }
            int decrease = (int)((1.0f - mod) * 100.0f);
            circuit.addTooltip("Decreases " + modifier.getName() + " by " + decrease + "%");
        }
    }

    public float getTerritoryModifier(@Nonnull IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.Territory, currentModifier);
    }

    public float getMutationModifier(@Nonnull IBeeGenome genome, @Nonnull IBeeGenome mate, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.Mutation, currentModifier);
    }

    public float getLifespanModifier(@Nonnull IBeeGenome genome, @Nullable IBeeGenome mate, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.Lifespan, currentModifier);
    }

    public float getProductionModifier(@Nonnull IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.Production, currentModifier);
    }

    public float getFloweringModifier(@Nonnull IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.Flowering, currentModifier);
    }

    public float getGeneticDecay(@Nonnull IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.GeneticDecay, currentModifier);
    }

    public boolean isSealed() {
        return this.logic.getModifier(EnumBeeBooleanModifier.Sealed);
    }

    public boolean isSelfLighted() {
        return this.logic.getModifier(EnumBeeBooleanModifier.SelfLighted);
    }

    public boolean isSunlightSimulated() {
        return this.logic.getModifier(EnumBeeBooleanModifier.SunlightStimulated);
    }

    public boolean isHellish() {
        return this.logic.getModifier(EnumBeeBooleanModifier.Hellish);
    }

    static {
        AlvearySimulatorCircuitType.LowVoltage.logic.setModifier(EnumBeeModifier.Production, 1.5f, 5.0f);
        AlvearySimulatorCircuitType.HighVoltage.logic.setModifier(EnumBeeModifier.Production, 2.5f, 10.0f);
        AlvearySimulatorCircuitType.Plant.logic.setModifier(EnumBeeModifier.Flowering, 1.5f, 5.0f);
        AlvearySimulatorCircuitType.Death.logic.setModifier(EnumBeeModifier.Lifespan, 0.8f, 0.2f);
        AlvearySimulatorCircuitType.Life.logic.setModifier(EnumBeeModifier.Lifespan, 1.5f, 5.0f);
        AlvearySimulatorCircuitType.Nether.logic.setModifier(EnumBeeBooleanModifier.Hellish);
        AlvearySimulatorCircuitType.Mutation.logic.setModifier(EnumBeeModifier.Mutation, 1.5f, 5.0f);
        AlvearySimulatorCircuitType.Inhibitor.logic.setModifier(EnumBeeModifier.Territory, 0.4f, 0.1f);
        AlvearySimulatorCircuitType.Inhibitor.logic.setModifier(EnumBeeModifier.Production, 0.9f, 0.5f);
        AlvearySimulatorCircuitType.Territory.logic.setModifier(EnumBeeModifier.Territory, 1.5f, 5.0f);
        for (AlvearySimulatorCircuitType type : AlvearySimulatorCircuitType.values()) {
            type.logic.setModifier(EnumBeeModifier.GeneticDecay, 1.5f, 10.0f);
        }
    }
}

