/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.genetics;

import binnie.genetics.genetics.GeneProject;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class GeneProjectTracker
extends WorldSavedData {
    private Map<Integer, GeneProject> projects = new HashMap<Integer, GeneProject>();
    private Map<GameProfile, Set<Integer>> TeamInvites = new HashMap<GameProfile, Set<Integer>>();

    public GeneProjectTracker(String s) {
        super(s);
    }

    public static GeneProjectTracker getTracker(World world) {
        String filename = "GeneProjectTracker.common";
        GeneProjectTracker tracker = (GeneProjectTracker)world.func_72943_a(GeneProjectTracker.class, filename);
        if (tracker == null) {
            tracker = new GeneProjectTracker(filename);
            world.func_72823_a(filename, (WorldSavedData)tracker);
        }
        return tracker;
    }

    public void func_76184_a(NBTTagCompound nbt) {
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        return nbt;
    }

    public int createProject(String name, GameProfile leader) {
        int i = 1;
        while (this.projects.keySet().contains(i)) {
            ++i;
        }
        GeneProject project = new GeneProject(i, name, leader);
        this.projects.put(i, project);
        this.func_76185_a();
        return i;
    }

    public void removeProject(int id) {
        this.projects.remove(id);
        for (Map.Entry<GameProfile, Set<Integer>> entry : this.TeamInvites.entrySet()) {
            entry.getValue().remove(id);
        }
        this.func_76185_a();
    }

    public void leaveProject(int id, GameProfile player) {
        GeneProject project = this.projects.get(id);
        if (project == null) {
            return;
        }
        project.removePlayer(player);
        if (project.isEmpty()) {
            this.removeProject(id);
        }
        this.func_76185_a();
    }

    public void joinProject(int id, GameProfile player) {
        GeneProject project = this.projects.get(id);
        if (project == null) {
            return;
        }
        project.addPlayer(player);
        this.func_76185_a();
    }

    public void reassignPlayer(int id, int id2, GameProfile player) {
        GeneProject project = this.projects.get(id);
        if (project == null) {
            return;
        }
        GeneProject project2 = this.projects.get(id2);
        if (project2 == null) {
            return;
        }
        this.leaveProject(id, player);
        this.joinProject(id2, player);
    }

    public void renameProject(int id, String newName) {
        GeneProject project = this.projects.get(id);
        if (project != null) {
            project.setName(newName);
        }
        this.func_76185_a();
    }

    public void invitePlayer(int id, GameProfile player) {
        if (!this.TeamInvites.containsKey(player)) {
            this.TeamInvites.put(player, new LinkedHashSet());
        }
        this.TeamInvites.get(player).add(id);
        this.func_76185_a();
    }

    public void revokeInvite(int id, GameProfile player) {
        if (!this.TeamInvites.containsKey(player)) {
            this.TeamInvites.put(player, new LinkedHashSet());
        }
        this.TeamInvites.get(player).add(id);
        this.func_76185_a();
    }
}

