/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.proxy;

import binnie.core.craftgui.resource.minecraft.CraftGUIResourceManager;
import binnie.core.models.ModelManager;
import binnie.core.proxy.BinnieProxy;
import binnie.core.proxy.IBinnieProxy;
import binnie.core.resource.BinnieResource;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class BinnieProxyClient
extends BinnieProxy
implements IBinnieProxy {
    public static ModelManager modelManager = new ModelManager("binniecore");

    public static ModelManager getModelManager() {
        return modelManager;
    }

    @Override
    public Item registerItem(Item item) {
        BinnieProxyClient.getModelManager().registerItemClient(item);
        return super.registerItem(item);
    }

    @Override
    public Block registerBlock(Block block) {
        BinnieProxyClient.getModelManager().registerBlockClient(block);
        return super.registerBlock(block);
    }

    @Override
    public void registerModels() {
        BinnieProxyClient.getModelManager().registerModels();
    }

    @Override
    public void reloadSprites() {
        ModelManager.reloadSprites();
    }

    @Override
    public void registerItemAndBlockColors() {
        BinnieProxyClient.getModelManager().registerItemAndBlockColors();
    }

    @Override
    public void registerSprite(ResourceLocation location) {
        Minecraft.func_71410_x().func_147117_R().func_174942_a(location);
    }

    @Override
    public void registerModel(Item item, int meta) {
        this.registerModel(item, meta, new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    @Override
    public void registerModel(Item item, int meta, ModelResourceLocation modelResourceLocation) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)modelResourceLocation);
    }

    @Override
    public void bindTexture(BinnieResource texture) {
        this.bindTexture(texture.getResourceLocation());
    }

    @Override
    public void bindTexture(ResourceLocation location) {
        this.getMinecraftInstance().func_110434_K().func_110577_a(location);
    }

    @Override
    public boolean checkTexture(BinnieResource location) {
        SimpleTexture texture = new SimpleTexture(location.getResourceLocation());
        try {
            texture.func_110551_a(this.getMinecraftInstance().func_110442_L());
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isSimulating(World world) {
        return !world.field_72995_K;
    }

    @Override
    public World getWorld() {
        return this.getMinecraftInstance().field_71441_e;
    }

    @Override
    public Minecraft getMinecraftInstance() {
        return FMLClientHandler.instance().getClient();
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public boolean isServer() {
        return false;
    }

    @Override
    public File getDirectory() {
        return new File(".");
    }

    @Override
    public void registerTileEntity(Class<? extends TileEntity> tile, String id, @Nullable Object renderer) {
        if (renderer != null && renderer instanceof TileEntitySpecialRenderer) {
            ClientRegistry.registerTileEntity(tile, (String)id, (TileEntitySpecialRenderer)((TileEntitySpecialRenderer)renderer));
        } else {
            GameRegistry.registerTileEntity(tile, (String)id);
        }
    }

    @Override
    public void registerBlockRenderer(Object renderer) {
    }

    @Override
    public void createPipe(Item pipe) {
    }

    @Override
    public Object createObject(String renderer) {
        try {
            Class<?> rendererClass = Class.forName(renderer);
            if (rendererClass != null) {
                return rendererClass.newInstance();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw Throwables.propagate((Throwable)e);
        }
        throw new IllegalArgumentException("Could not create object for class name " + renderer);
    }

    @Override
    public TextureAtlasSprite getTextureAtlasSprite(ResourceLocation location) {
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
    }

    @Override
    public EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void preInit() {
        IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
        if (manager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)manager).func_110542_a((IResourceManagerReloadListener)new CraftGUIResourceManager());
        }
    }
}

