/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import binnie.Binnie;
import binnie.core.genetics.BreedingSystem;
import binnie.core.genetics.ForestryAllele;
import binnie.core.util.I18N;
import binnie.core.util.UniqueItemStackSet;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.machines.lumbermill.LumbermillRecipes;
import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IArboristTracker;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeMutation;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.genetics.ISpeciesType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class TreeBreedingSystem
extends BreedingSystem {
    public UniqueItemStackSet allFruits = new UniqueItemStackSet();
    public UniqueItemStackSet allWoods = new UniqueItemStackSet();
    public UniqueItemStackSet discoveredPlanks;
    private UniqueItemStackSet discoveredFruits = new UniqueItemStackSet();
    private UniqueItemStackSet discoveredWoods = new UniqueItemStackSet();

    public TreeBreedingSystem() {
        this.discoveredPlanks = new UniqueItemStackSet();
        this.iconUndiscovered = Binnie.RESOURCE.getItemSprite(ExtraTrees.instance, "icon/undiscovered_tree");
        this.iconDiscovered = Binnie.RESOURCE.getItemSprite(ExtraTrees.instance, "icon/discovered_tree");
    }

    @Override
    public float getChance(IMutation mutation, EntityPlayer player, IAlleleSpecies species1, IAlleleSpecies species2) {
        ISpeciesRoot speciesRoot = this.getSpeciesRoot();
        ITreeGenome genome0 = (ITreeGenome)speciesRoot.templateAsGenome(speciesRoot.getTemplate(species1));
        ITreeGenome genome2 = (ITreeGenome)speciesRoot.templateAsGenome(speciesRoot.getTemplate(species2));
        return ((ITreeMutation)mutation).getChance(player.field_70170_p, player.func_180425_c(), (IAlleleTreeSpecies)species1, (IAlleleTreeSpecies)species2, genome0, genome2);
    }

    @Override
    public ISpeciesRoot getSpeciesRoot() {
        return Binnie.GENETICS.getTreeRoot();
    }

    @Override
    public int getColour() {
        return 53006;
    }

    @Override
    public Class<? extends IBreedingTracker> getTrackerClass() {
        return IArboristTracker.class;
    }

    @Override
    public String getAlleleName(IChromosomeType chromosome, IAllele allele) {
        if (chromosome == EnumTreeChromosome.GIRTH) {
            return ((IAlleleInteger)allele).getValue() + "x" + ((IAlleleInteger)allele).getValue();
        }
        if (chromosome == EnumTreeChromosome.FRUITS && allele.getUID().contains(".")) {
            IFruitProvider provider = ((IAlleleFruit)allele).getProvider();
            return provider.getProducts().size() == 0 ? I18N.localise("binniecore.allele.none") : ((ItemStack)provider.getProducts().keySet().iterator().next()).func_82833_r();
        }
        return super.getAlleleName(chromosome, allele);
    }

    @Override
    public void onSyncBreedingTracker(IBreedingTracker tracker) {
        this.discoveredFruits.clear();
        this.discoveredWoods.clear();
        for (IAlleleSpecies species : this.getDiscoveredSpecies(tracker)) {
            IAlleleTreeSpecies tSpecies = (IAlleleTreeSpecies)species;
            ITreeGenome genome = (ITreeGenome)this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate((IAlleleSpecies)tSpecies));
            IAlleleTreeSpecies treeSpecies = genome.getPrimary();
            ItemStack wood = treeSpecies.getWoodProvider().getWoodStack();
            if (!wood.func_190926_b()) {
                this.discoveredWoods.add(wood);
            }
            this.discoveredFruits.addAll(genome.getFruitProvider().getProducts().keySet());
            for (ItemStack itemStack : this.discoveredWoods) {
            }
        }
    }

    @Override
    public final void calculateArrays() {
        super.calculateArrays();
        for (IAlleleSpecies species : this.allActiveSpecies) {
            IAlleleTreeSpecies tSpecies = (IAlleleTreeSpecies)species;
            ITreeGenome genome = (ITreeGenome)this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate((IAlleleSpecies)tSpecies));
            IAlleleTreeSpecies treeSpecies = genome.getPrimary();
            ItemStack wood = treeSpecies.getWoodProvider().getWoodStack();
            if (!wood.func_190926_b()) {
                this.allWoods.add(wood);
            }
            this.allFruits.addAll(genome.getFruitProvider().getProducts().keySet());
        }
    }

    public Collection<IAlleleSpecies> getTreesThatBearFruit(ItemStack fruit, boolean nei, World world, GameProfile player) {
        Collection<IAlleleSpecies> set = nei ? this.getAllSpecies() : this.getDiscoveredSpecies(world, player);
        ArrayList<IAlleleSpecies> found = new ArrayList<IAlleleSpecies>();
        for (IAlleleSpecies species : set) {
            IAlleleTreeSpecies tSpecies = (IAlleleTreeSpecies)species;
            ITreeGenome genome = (ITreeGenome)this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate((IAlleleSpecies)tSpecies));
            for (ItemStack fruit2 : genome.getFruitProvider().getProducts().keySet()) {
                if (!fruit2.func_77969_a(fruit)) continue;
                found.add(species);
            }
        }
        return found;
    }

    public Collection<IAlleleSpecies> getTreesThatCanBearFruit(ItemStack fruit, boolean nei, World world, GameProfile player) {
        IAlleleTreeSpecies tSpecies;
        Collection<IAlleleSpecies> set = nei ? this.getAllSpecies() : this.getDiscoveredSpecies(world, player);
        ArrayList<IAlleleSpecies> found = new ArrayList<IAlleleSpecies>();
        HashSet<IFruitFamily> providers = new HashSet<IFruitFamily>();
        for (IAlleleSpecies species : set) {
            tSpecies = (IAlleleTreeSpecies)species;
            ITreeGenome genome = (ITreeGenome)this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate((IAlleleSpecies)tSpecies));
            for (ItemStack fruit2 : genome.getFruitProvider().getProducts().keySet()) {
                if (!fruit2.func_77969_a(fruit)) continue;
                providers.add(genome.getFruitProvider().getFamily());
            }
        }
        block2: for (IAlleleSpecies species : set) {
            tSpecies = (IAlleleTreeSpecies)species;
            for (IFruitFamily family : providers) {
                if (!tSpecies.getSuitableFruit().contains(family)) continue;
                found.add(species);
                continue block2;
            }
        }
        return found;
    }

    public Collection<IAlleleSpecies> getTreesThatHaveWood(ItemStack wood, boolean nei, World world, GameProfile player) {
        Collection<IAlleleSpecies> set = nei ? this.getAllSpecies() : this.getDiscoveredSpecies(world, player);
        ArrayList<IAlleleSpecies> found = new ArrayList<IAlleleSpecies>();
        for (IAlleleSpecies species : set) {
            IAlleleTreeSpecies tSpecies = (IAlleleTreeSpecies)species;
            ITreeGenome genome = TreeManager.treeRoot.templateAsGenome(TreeManager.treeRoot.getTemplate((IAlleleSpecies)tSpecies));
            IAlleleTreeSpecies treeSpecies = genome.getPrimary();
            ItemStack woodStack = treeSpecies.getWoodProvider().getWoodStack();
            if (!woodStack.func_77969_a(wood)) continue;
            found.add(species);
        }
        return found;
    }

    public Collection<IAlleleSpecies> getTreesThatMakePlanks(ItemStack fruit, boolean nei, World world, GameProfile player) {
        if (fruit == null) {
            return new ArrayList<IAlleleSpecies>();
        }
        Collection<IAlleleSpecies> set = nei ? this.getAllSpecies() : this.getDiscoveredSpecies(world, player);
        ArrayList<IAlleleSpecies> found = new ArrayList<IAlleleSpecies>();
        for (IAlleleSpecies species : set) {
            IAlleleTreeSpecies tSpecies = (IAlleleTreeSpecies)species;
            ITreeGenome genome = TreeManager.treeRoot.templateAsGenome(TreeManager.treeRoot.getTemplate((IAlleleSpecies)tSpecies));
            IAlleleTreeSpecies treeSpecies = genome.getPrimary();
            ItemStack woodStack = treeSpecies.getWoodProvider().getWoodStack();
            ItemStack plankProduct = LumbermillRecipes.getPlankProduct(woodStack);
            if (plankProduct.func_190926_b() || !fruit.func_77969_a(plankProduct)) continue;
            found.add(species);
        }
        return found;
    }

    @Override
    public boolean isDNAManipulable(ItemStack member) {
        ISpeciesType type = this.getSpeciesRoot().getType(member);
        return this.isDNAManipulable(type);
    }

    @Override
    public boolean isDNAManipulable(@Nullable ISpeciesType type) {
        return type == EnumGermlingType.POLLEN;
    }

    @Override
    @Nullable
    public IIndividual getConversion(ItemStack stack) {
        return TreeManager.treeRoot.getMember(stack);
    }

    @Override
    public ISpeciesType[] getActiveTypes() {
        return new ISpeciesType[]{EnumGermlingType.SAPLING, EnumGermlingType.POLLEN};
    }

    @Override
    public void addExtraAlleles(IChromosomeType chromosome, TreeSet<IAllele> alleles) {
        switch ((EnumTreeChromosome)chromosome) {
            case FERTILITY: {
                for (ForestryAllele.Saplings a : ForestryAllele.Saplings.values()) {
                    alleles.add(a.getAllele());
                }
                break;
            }
            case GIRTH: {
                for (ForestryAllele.Int a2 : ForestryAllele.Int.values()) {
                    alleles.add(a2.getAllele());
                }
                break;
            }
            case HEIGHT: {
                for (ForestryAllele.TreeHeight a3 : ForestryAllele.TreeHeight.values()) {
                    alleles.add(a3.getAllele());
                }
                break;
            }
            case MATURATION: {
                for (ForestryAllele.Maturation a4 : ForestryAllele.Maturation.values()) {
                    alleles.add(a4.getAllele());
                }
                break;
            }
            case SAPPINESS: {
                for (ForestryAllele.Sappiness a5 : ForestryAllele.Sappiness.values()) {
                    alleles.add(a5.getAllele());
                }
                break;
            }
            case YIELD: {
                for (ForestryAllele.Yield a7 : ForestryAllele.Yield.values()) {
                    alleles.add(a7.getAllele());
                }
                break;
            }
            case FIREPROOF: {
                for (ForestryAllele.Bool a8 : ForestryAllele.Bool.values()) {
                    alleles.add(a8.getAllele());
                }
                break;
            }
        }
    }
}

