/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.polymeriser;

import binnie.core.craftgui.minecraft.IMachineInformation;
import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.inventory.ComponentChargedSlots;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentInventoryTransfer;
import binnie.core.machines.inventory.ComponentTankContainer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.inventory.Validator;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.genetics.core.GeneticsGUI;
import binnie.genetics.core.GeneticsTexture;
import binnie.genetics.item.GeneticLiquid;
import binnie.genetics.machine.ComponentGeneticGUI;
import binnie.genetics.machine.GeneticMachine;
import binnie.genetics.machine.ModuleMachine;
import binnie.genetics.machine.polymeriser.Polymeriser;
import binnie.genetics.machine.polymeriser.PolymeriserFX;
import binnie.genetics.machine.polymeriser.PolymeriserLogic;
import binnie.genetics.machine.polymeriser.SlotValidatorUnfilledSerum;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;

public class PackagePolymeriser
extends GeneticMachine.PackageGeneticBase
implements IMachineInformation {
    public PackagePolymeriser() {
        super("polymeriser", GeneticsTexture.POLYMERISER, 58819, true);
    }

    @Override
    public void createMachine(Machine machine) {
        new ComponentGeneticGUI(machine, GeneticsGUI.POLYMERISER);
        ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
        InventorySlot slotGold = inventory.addSlot(1, "catalyst");
        slotGold.setValidator(new SlotValidator.Item(new ItemStack(Items.field_151074_bl, 1), ModuleMachine.spriteNugget));
        slotGold.forbidExtraction();
        InventorySlot slotSerum = inventory.addSlot(0, "process");
        slotSerum.setValidator(new SlotValidatorUnfilledSerum());
        slotSerum.forbidInteraction();
        slotSerum.setReadOnly();
        for (InventorySlot slot : inventory.addSlotArray(Polymeriser.SLOT_SERUM_RESERVE, "input")) {
            slot.setValidator(new SlotValidatorUnfilledSerum());
            slot.forbidExtraction();
        }
        for (InventorySlot slot : inventory.addSlotArray(Polymeriser.SLOT_SERUM_FINISHED, "output")) {
            slot.setReadOnly();
        }
        ComponentInventoryTransfer transfer = new ComponentInventoryTransfer(machine);
        transfer.addRestock(Polymeriser.SLOT_SERUM_RESERVE, 0, 1);
        transfer.addStorage(0, Polymeriser.SLOT_SERUM_FINISHED, new ComponentInventoryTransfer.Condition(){

            @Override
            public boolean fulfilled(ItemStack stack) {
                return !stack.func_77951_h();
            }
        });
        ComponentTankContainer tank = new ComponentTankContainer(machine);
        tank.addTank(0, "input", 1000).setValidator(new Validator<FluidStack>(){

            @Override
            public boolean isValid(FluidStack itemStack) {
                return GeneticLiquid.BacteriaPoly.get(1).isFluidEqual(itemStack);
            }

            @Override
            public String getTooltip() {
                return GeneticLiquid.BacteriaPoly.get(1).getLocalizedName();
            }
        });
        tank.addTank(1, "input", 1000).setValidator(new Validator<FluidStack>(){

            @Override
            public boolean isValid(FluidStack itemStack) {
                return GeneticLiquid.RawDNA.get(1).isFluidEqual(itemStack);
            }

            @Override
            public String getTooltip() {
                return GeneticLiquid.RawDNA.get(1).getLocalizedName();
            }
        });
        new ComponentChargedSlots(machine).addCharge(1);
        new ComponentPowerReceptor(machine, 8000);
        new PolymeriserLogic(machine);
        new PolymeriserFX(machine);
    }

    @Override
    public TileEntity createTileEntity() {
        return new TileEntityMachine(this);
    }

    @Override
    public void register() {
    }
}

