/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.items.types;

import binnie.core.util.I18N;
import binnie.extrabees.items.ItemHiveFrame;
import binnie.extrabees.utils.BeeModifierLogic;
import binnie.extrabees.utils.EnumBeeBooleanModifier;
import binnie.extrabees.utils.EnumBeeModifier;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IHiveFrame;
import forestry.apiculture.PluginApiculture;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum EnumHiveFrame implements IHiveFrame,
IBeeModifier
{
    Cocoa,
    Cage,
    Soul(80),
    Clay,
    Debug;

    private final Item item;
    private final int maxDamage;
    private final BeeModifierLogic logic;

    private EnumHiveFrame() {
        this(240);
    }

    private EnumHiveFrame(int maxDamage) {
        this.maxDamage = maxDamage;
        this.logic = new BeeModifierLogic();
        this.item = (Item)new ItemHiveFrame(this).setRegistryName("hive_frame." + this.name().toLowerCase());
    }

    public static void init() {
        EnumHiveFrame.Cocoa.logic.setModifier(EnumBeeModifier.Lifespan, 0.75f, 0.25f);
        EnumHiveFrame.Cocoa.logic.setModifier(EnumBeeModifier.Production, 1.5f, 5.0f);
        EnumHiveFrame.Cage.logic.setModifier(EnumBeeModifier.Territory, 0.5f, 0.1f);
        EnumHiveFrame.Cage.logic.setModifier(EnumBeeModifier.Lifespan, 0.75f, 0.5f);
        EnumHiveFrame.Cage.logic.setModifier(EnumBeeModifier.Production, 0.75f, 0.5f);
        EnumHiveFrame.Soul.logic.setModifier(EnumBeeModifier.Mutation, 1.5f, 5.0f);
        EnumHiveFrame.Soul.logic.setModifier(EnumBeeModifier.Lifespan, 0.75f, 0.5f);
        EnumHiveFrame.Soul.logic.setModifier(EnumBeeModifier.Production, 0.25f, 0.1f);
        EnumHiveFrame.Clay.logic.setModifier(EnumBeeModifier.Lifespan, 1.5f, 5.0f);
        EnumHiveFrame.Clay.logic.setModifier(EnumBeeModifier.Mutation, 0.5f, 0.2f);
        EnumHiveFrame.Clay.logic.setModifier(EnumBeeModifier.Production, 0.75f, 0.2f);
        EnumHiveFrame.Debug.logic.setModifier(EnumBeeModifier.Lifespan, 1.0E-4f, 1.0E-4f);
        ItemStack impregnatedFrame = PluginApiculture.getItems().frameImpregnated.getItemStack();
        GameRegistry.addRecipe((ItemStack)new ItemStack(EnumHiveFrame.Cocoa.item), (Object[])new Object[]{" c ", "cFc", " c ", Character.valueOf('F'), impregnatedFrame, Character.valueOf('c'), new ItemStack(Items.field_151100_aR, 1, 3)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(EnumHiveFrame.Cage.item), (Object[])new Object[]{impregnatedFrame, Blocks.field_150411_aY});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(EnumHiveFrame.Soul.item), (Object[])new Object[]{impregnatedFrame, Blocks.field_150425_aM});
        GameRegistry.addRecipe((ItemStack)new ItemStack(EnumHiveFrame.Clay.item), (Object[])new Object[]{" c ", "cFc", " c ", Character.valueOf('F'), impregnatedFrame, Character.valueOf('c'), Items.field_151119_aD});
    }

    public int getIconIndex() {
        return 55 + this.ordinal();
    }

    public int getMaxDamage() {
        return this.maxDamage;
    }

    public ItemStack frameUsed(IBeeHousing house, ItemStack frame, IBee queen, int wear) {
        frame.func_77964_b(frame.func_77952_i() + wear);
        if (frame.func_77952_i() >= frame.func_77958_k()) {
            return ItemStack.field_190927_a;
        }
        return frame;
    }

    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.Territory, currentModifier);
    }

    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.Mutation, currentModifier);
    }

    public float getLifespanModifier(IBeeGenome genome, @Nullable IBeeGenome mate, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.Lifespan, currentModifier);
    }

    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.Production, currentModifier);
    }

    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.Flowering, currentModifier);
    }

    public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.GeneticDecay, currentModifier);
    }

    public boolean isSealed() {
        return this.logic.getModifier(EnumBeeBooleanModifier.Sealed);
    }

    public boolean isSelfLighted() {
        return this.logic.getModifier(EnumBeeBooleanModifier.SelfLighted);
    }

    public boolean isSunlightSimulated() {
        return this.logic.getModifier(EnumBeeBooleanModifier.SunlightStimulated);
    }

    public boolean isHellish() {
        return this.logic.getModifier(EnumBeeBooleanModifier.Hellish);
    }

    public String getName() {
        return I18N.localise("extrabees.item.frame." + this.toString().toLowerCase());
    }

    public IBeeModifier getBeeModifier() {
        return this;
    }

    public Item getItem() {
        return this.item;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        this.logic.addInformation(stack, playerIn, tooltip, advanced);
    }
}

