/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.core;

import binnie.core.BinnieCore;
import binnie.core.IInitializable;
import binnie.extratrees.api.CarpentryManager;
import binnie.extratrees.api.IDesign;
import binnie.extratrees.api.IDesignMaterial;
import binnie.extratrees.block.EnumETLog;
import binnie.extratrees.block.PlankType;
import binnie.extratrees.genetics.AlleleETFruit;
import binnie.extratrees.genetics.ETTreeDefinition;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.LinkedList;

public class ModuleCore
implements IInitializable {
    @Override
    public void preInit() {
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
        if (BinnieCore.getBinnieProxy().isDebug()) {
            try {
                String img2;
                String img;
                int i;
                PrintWriter outputSpecies = new PrintWriter(new FileWriter("data/species.html"));
                PrintWriter outputLogs = new PrintWriter(new FileWriter("data/logs.html"));
                PrintWriter outputPlanks = new PrintWriter(new FileWriter("data/planks.html"));
                PrintWriter outputFruit = new PrintWriter(new FileWriter("data/fruit.html"));
                PrintWriter outputDesigns = new PrintWriter(new FileWriter("data/designs.html"));
                LinkedList<IAlleleTreeSpecies> speciesQueue = new LinkedList<IAlleleTreeSpecies>();
                for (ETTreeDefinition s : ETTreeDefinition.values()) {
                    speciesQueue.add(s.getSpecies());
                }
                LinkedList logQueue = new LinkedList();
                Collections.addAll(logQueue, EnumETLog.values());
                LinkedList plankQueue = new LinkedList();
                Collections.addAll(plankQueue, PlankType.ExtraTreePlanks.values());
                LinkedList<AlleleETFruit> fruitQueue = new LinkedList<AlleleETFruit>();
                fruitQueue.addAll(AlleleETFruit.values());
                LinkedList<IDesign> designQueue = new LinkedList<IDesign>();
                designQueue.addAll(CarpentryManager.carpentryInterface.getSortedDesigns());
                fruitQueue.remove((Object)AlleleETFruit.Apple);
                outputSpecies.println("<table style=\"width: 100%;\">");
                while (!speciesQueue.isEmpty()) {
                    outputSpecies.println("<tr>");
                    for (i = 0; i < 4; ++i) {
                        IAlleleTreeSpecies species = (IAlleleTreeSpecies)speciesQueue.poll();
                        outputSpecies.println("<td>" + (species == null ? "" : species.getName()) + "</td>");
                    }
                    outputSpecies.println("</tr>");
                }
                outputSpecies.println("</table>");
                outputLogs.println("<table style=\"width: 100%;\">");
                while (!logQueue.isEmpty()) {
                    outputLogs.println("<tr>");
                    for (i = 0; i < 4; ++i) {
                        EnumETLog wood5 = (EnumETLog)((Object)logQueue.poll());
                        if (wood5 == null) {
                            outputLogs.println("<td></td>");
                            continue;
                        }
                        img = "<img alt=\"" + wood5.func_176610_l() + "\" src=\"images/logs/" + wood5.toString().toLowerCase() + "Bark.png\">";
                        outputLogs.println("<td>" + img + " " + wood5.func_176610_l() + "</td>");
                    }
                    outputLogs.println("</tr>");
                }
                outputLogs.println("</table>");
                outputPlanks.println("<table style=\"width: 100%;\">");
                while (!plankQueue.isEmpty()) {
                    outputPlanks.println("<tr>");
                    for (i = 0; i < 4; ++i) {
                        IDesignMaterial wood2 = (IDesignMaterial)plankQueue.poll();
                        if (wood2 == null) {
                            outputPlanks.println("<td></td>");
                            continue;
                        }
                        img = "<img alt=\"" + wood2.getDesignMaterialName() + "\" src=\"images/planks/" + wood2.getDesignMaterialName() + ".png\">";
                        outputPlanks.println("<td>" + img + " " + wood2.getDesignMaterialName() + "</td>");
                    }
                    outputPlanks.println("</tr>");
                }
                outputPlanks.println("</table>");
                outputFruit.println("<table style=\"width: 100%;\">");
                while (!fruitQueue.isEmpty()) {
                    outputFruit.println("<tr>");
                    for (i = 0; i < 4; ++i) {
                        AlleleETFruit wood6 = (AlleleETFruit)((Object)fruitQueue.poll());
                        if (wood6 == null) {
                            outputFruit.println("<td></td>");
                            continue;
                        }
                        String fruit = wood6.getNameOfFruit();
                        img2 = "<img alt=\"" + wood6.getName() + "\" src=\"images/fruits/" + fruit + ".png\">";
                        outputFruit.println("<td>" + img2 + " " + wood6.getName() + "</td>");
                    }
                    outputFruit.println("</tr>");
                }
                outputFruit.println("</table>");
                outputDesigns.println("<table style=\"width: 100%;\">");
                while (!designQueue.isEmpty()) {
                    outputDesigns.println("<tr>");
                    for (i = 0; i < 4; ++i) {
                        IDesign wood4 = (IDesign)designQueue.poll();
                        if (wood4 == null) {
                            outputDesigns.println("<td></td>");
                            continue;
                        }
                        String texture = wood4.getTopPattern().getPattern().toString().toLowerCase();
                        img2 = "<img alt=\"" + texture + "\" src=\"images/pattern/" + texture + ".png\">";
                        outputDesigns.println("<td>" + img2 + " " + wood4.getName() + "</td>");
                    }
                    outputDesigns.println("</tr>");
                }
                outputDesigns.println("</table>");
                outputSpecies.close();
                outputLogs.close();
                outputPlanks.close();
                outputFruit.close();
                outputDesigns.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

