/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.controls.tab;

import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.controls.core.IControlValue;
import binnie.core.craftgui.controls.tab.ControlTab;
import binnie.core.craftgui.events.EventHandler;
import binnie.core.craftgui.events.EventValueChanged;
import binnie.core.craftgui.geometry.Position;
import com.google.common.collect.Iterables;
import java.util.Collection;

public class ControlTabBar<T>
extends Control
implements IControlValue<T> {
    private T value;
    private Position position;

    public ControlTabBar(IWidget parent, int x, int y, int width, int height, Position position, Collection<T> values) {
        this(parent, x, y, width, height, position, Iterables.get(values, (int)0));
        super.setValues(values);
    }

    public ControlTabBar(IWidget parent, int x, int y, int width, int height, Position position, T value) {
        super(parent, x, y, width, height);
        this.value = value;
        this.position = position;
        this.addEventHandler(new EventValueChanged.Handler(){

            @Override
            public void onEvent(EventValueChanged event) {
                ControlTabBar.this.setValue(event.getValue());
            }
        }.setOrigin(EventHandler.Origin.DirectChild, this));
    }

    private void setValues(Collection<T> values) {
        boolean i = false;
        while (0 < this.getWidgets().size()) {
            this.deleteChild(this.getWidgets().get(0));
        }
        float length = values.size();
        int tabDimension = (int)((float)this.getSize().y() / length);
        if (this.position == Position.Top || this.position == Position.BOTTOM) {
            tabDimension = (int)((float)this.getSize().x() / length);
        }
        int j = 0;
        for (T value : values) {
            ControlTab<T> controlTab = this.position == Position.Top || this.position == Position.BOTTOM ? this.createTab(j * tabDimension, 0, tabDimension, this.getSize().y(), value) : this.createTab(0, j * tabDimension, this.getSize().x(), tabDimension, value);
            ++j;
        }
    }

    public ControlTab<T> createTab(int x, int y, int w, int h, T value) {
        return new ControlTab<T>(this, x, y, w, h, value);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        boolean change = this.value != value;
        this.value = value;
        if (change) {
            this.callEvent(new EventValueChanged<T>(this, value));
        }
    }

    public Position getDirection() {
        return this.position;
    }
}

