/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol;

import binnie.Binnie;
import binnie.core.IInitializable;
import binnie.core.Mods;
import binnie.core.liquid.IFluidType;
import binnie.core.resource.BinnieSprite;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.alcohol.Alcohol;
import binnie.extratrees.alcohol.Cocktail;
import binnie.extratrees.alcohol.Glassware;
import binnie.extratrees.alcohol.ICocktailIngredient;
import binnie.extratrees.alcohol.Juice;
import binnie.extratrees.alcohol.Liqueur;
import binnie.extratrees.alcohol.Spirit;
import binnie.extratrees.alcohol.drink.DrinkLiquid;
import binnie.extratrees.alcohol.drink.DrinkManager;
import binnie.extratrees.alcohol.drink.ItemDrink;
import binnie.extratrees.item.ExtraTreeItems;
import binnie.extratrees.item.Food;
import binnie.extratrees.machines.brewery.BrewedGrainRecipe;
import binnie.extratrees.machines.brewery.BreweryRecipes;
import binnie.extratrees.machines.distillery.DistilleryRecipes;
import binnie.extratrees.machines.fruitpress.FruitPressRecipes;
import forestry.api.recipes.ISqueezerRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.core.fluids.Fluids;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class ModuleAlcohol
implements IInitializable {
    public ItemDrink drink;
    public Block blockDrink;
    public int drinkRendererID;
    public BinnieSprite liquid;

    @Override
    public void preInit() {
        this.liquid = Binnie.RESOURCE.getBlockSprite(ExtraTrees.instance, "liquids/liquid");
        this.drink = new ItemDrink();
        ExtraTrees.proxy.registerItem((Item)this.drink);
        Binnie.LIQUID.createLiquids(Juice.values());
        Binnie.LIQUID.createLiquids(Alcohol.values());
        Binnie.LIQUID.createLiquids(Spirit.values());
        Binnie.LIQUID.createLiquids(Liqueur.values());
        for (Juice juice : Juice.values()) {
            Cocktail.registerIngredient(juice);
        }
        for (Enum enum_ : Alcohol.values()) {
            Cocktail.registerIngredient((ICocktailIngredient)((Object)enum_));
        }
        for (Enum enum_ : Spirit.values()) {
            Cocktail.registerIngredient((ICocktailIngredient)((Object)enum_));
        }
        for (Enum enum_ : Liqueur.values()) {
            Cocktail.registerIngredient((ICocktailIngredient)((Object)enum_));
        }
        DrinkManager.registerDrinkLiquid(new DrinkLiquid("Water", 0xCCCCFF, 0.1f, 0.0f, "water"));
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
        ItemStack wax = Mods.Forestry.stack("beeswax");
        ItemStack waxCast = Mods.Forestry.stackWildcard("wax_cast");
        for (Glassware glassware : Glassware.values()) {
            ItemStack result = this.drink.getStack(glassware, null, 8);
            Object[] recipe = glassware.getRecipePattern(wax.func_77973_b());
            RecipeManagers.fabricatorManager.addRecipe(waxCast, Fluids.GLASS.getFluid(glassware.getRecipeGlassCost()), result, recipe);
        }
        for (Enum enum_ : Juice.values()) {
            String oreDict = ((Juice)enum_).squeezing;
            ArrayList<ItemStack> ores = new ArrayList<ItemStack>();
            ores.addAll((Collection<ItemStack>)OreDictionary.getOres((String)oreDict));
            for (Food food : Food.values()) {
                if (!food.getOres().contains(oreDict)) continue;
                ores.add(food.get(1));
            }
            for (ItemStack stack : ores) {
                for (ISqueezerRecipe entry : RecipeManagers.squeezerManager.recipes()) {
                    ItemStack input = (ItemStack)entry.getResources().get(0);
                    FluidStack output = entry.getFluidOutput();
                    if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)input) && !OreDictionary.itemMatches((ItemStack)input, (ItemStack)stack, (boolean)true)) continue;
                    int amount = output.amount;
                    if (Objects.equals(output.getFluid().getName(), "seedoil")) {
                        amount *= 2;
                    }
                    FruitPressRecipes.addRecipe(stack, ((Juice)enum_).get(amount));
                }
            }
        }
        for (Enum enum_ : Alcohol.values()) {
            for (String fermentLiquid : ((Alcohol)enum_).fermentationLiquid) {
                FluidStack fluid = Binnie.LIQUID.getFluidStack(fermentLiquid, 1000);
                if (fluid == null) continue;
                BreweryRecipes.addRecipe(fluid, ((Alcohol)enum_).get(1000));
            }
        }
        BreweryRecipes.addRecipes(new BrewedGrainRecipe(Alcohol.Ale, BreweryRecipes.GRAIN_BARLEY, BreweryRecipes.HOPS), new BrewedGrainRecipe(Alcohol.Lager, BreweryRecipes.GRAIN_BARLEY, BreweryRecipes.HOPS, ExtraTreeItems.LagerYeast.get(1)), new BrewedGrainRecipe(Alcohol.Stout, BreweryRecipes.GRAIN_ROASTED, BreweryRecipes.HOPS), new BrewedGrainRecipe(Alcohol.CornBeer, BreweryRecipes.GRAIN_CORN, BreweryRecipes.HOPS), new BrewedGrainRecipe(Alcohol.RyeBeer, BreweryRecipes.GRAIN_RYE, BreweryRecipes.HOPS), new BrewedGrainRecipe(Alcohol.WheatBeer, BreweryRecipes.GRAIN_WHEAT, BreweryRecipes.HOPS), new BrewedGrainRecipe(Alcohol.Barley, BreweryRecipes.GRAIN_BARLEY), new BrewedGrainRecipe(Alcohol.Corn, BreweryRecipes.GRAIN_CORN), new BrewedGrainRecipe(Alcohol.Rye, BreweryRecipes.GRAIN_RYE), new BrewedGrainRecipe(Alcohol.Wheat, BreweryRecipes.GRAIN_WHEAT));
        this.addDistillery(Alcohol.Apple, Spirit.AppleBrandy, Spirit.AppleLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Pear, Spirit.PearBrandy, Spirit.PearLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Apricot, Spirit.ApricotBrandy, Spirit.ApricotLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Banana, Spirit.FruitBrandy, Spirit.FruitLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Cherry, Spirit.CherryBrandy, Spirit.CherryLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Elderberry, Spirit.ElderberryBrandy, Spirit.ElderberryLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Peach, Spirit.FruitBrandy, Spirit.FruitLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Plum, Spirit.PlumBrandy, Spirit.FruitLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Carrot, Spirit.FruitBrandy, Spirit.Vodka, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.WhiteWine, Spirit.Brandy, Spirit.Brandy, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.RedWine, Spirit.Brandy, Spirit.Brandy, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.SparklingWine, Spirit.Brandy, Spirit.Brandy, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Agave, Spirit.Tequila, Spirit.Tequila, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Potato, Spirit.FruitBrandy, Spirit.Vodka, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Citrus, Spirit.CitrusBrandy, Spirit.FruitLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Cranberry, Spirit.FruitBrandy, Spirit.FruitLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Pineapple, Spirit.FruitBrandy, Spirit.FruitLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Tomato, Spirit.FruitBrandy, Spirit.FruitLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Fruit, Spirit.FruitBrandy, Spirit.FruitLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Barley, Spirit.Whiskey, Spirit.Vodka, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Wheat, Spirit.WheatWhiskey, Spirit.Vodka, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Rye, Spirit.RyeWhiskey, Spirit.Vodka, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Corn, Spirit.CornWhiskey, Spirit.Vodka, Spirit.NeutralSpirit);
    }

    private void addDistillery(IFluidType source, IFluidType singleDistilled, IFluidType doubleDistilled, IFluidType tripleDistilled) {
        int inAmount = 1000;
        int outAmount1 = 800;
        int outAmount2 = 400;
        int outAmount3 = 200;
        DistilleryRecipes.addRecipe(source.get(1000), singleDistilled.get(800), 0);
        DistilleryRecipes.addRecipe(source.get(1000), doubleDistilled.get(400), 1);
        DistilleryRecipes.addRecipe(source.get(1000), tripleDistilled.get(200), 2);
        DistilleryRecipes.addRecipe(singleDistilled.get(1000), doubleDistilled.get(400), 0);
        DistilleryRecipes.addRecipe(singleDistilled.get(1000), tripleDistilled.get(200), 1);
        DistilleryRecipes.addRecipe(doubleDistilled.get(1000), tripleDistilled.get(400), 0);
    }
}

