/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.gardening;

import binnie.botany.Botany;
import binnie.botany.CreativeTabBotany;
import binnie.botany.api.EnumAcidity;
import binnie.botany.api.EnumMoisture;
import binnie.botany.api.EnumSoilType;
import binnie.botany.api.IGardeningManager;
import binnie.botany.core.BotanyCore;
import com.google.common.collect.Multimap;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTrowel
extends Item
implements IItemModelRegister {
    protected final Item.ToolMaterial theToolMaterial;
    protected final String modelName;

    public ItemTrowel(Item.ToolMaterial toolMaterial, String materialName) {
        this.theToolMaterial = toolMaterial;
        this.func_77625_d(1);
        this.func_77656_e(toolMaterial.func_77997_a());
        this.func_77637_a(CreativeTabBotany.instance);
        this.modelName = "trowel_" + materialName;
        this.func_77655_b("botany." + this.modelName);
        this.setRegistryName(this.modelName);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        manager.registerItemModel(item, (ItemMeshDefinition)new ItemTrowelMeshDefinition());
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("botany:tools/" + this.modelName)});
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos, facing, stack)) {
            return EnumActionResult.FAIL;
        }
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (facing == EnumFacing.DOWN || !worldIn.func_175623_d(pos.func_177984_a()) && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != Botany.flower || block != Blocks.field_150349_c && block != Blocks.field_150346_d && block != Blocks.field_185774_da) {
            return EnumActionResult.PASS;
        }
        worldIn.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        IGardeningManager gardening = BotanyCore.getGardening();
        EnumMoisture moisture = gardening.getNaturalMoisture(worldIn, pos);
        EnumAcidity acidity = gardening.getNaturalPH(worldIn, pos);
        gardening.plantSoil(worldIn, pos, EnumSoilType.SOIL, moisture, acidity);
        stack.func_77972_a(1, (EntityLivingBase)player);
        return EnumActionResult.SUCCESS;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.theToolMaterial.func_78000_c() + 0.5, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -1.5, 0));
        }
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public String getToolMaterialName() {
        return this.theToolMaterial.toString();
    }

    @SideOnly(value=Side.CLIENT)
    private class ItemTrowelMeshDefinition
    implements ItemMeshDefinition {
        private ItemTrowelMeshDefinition() {
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            return new ModelResourceLocation("botany:tools/" + ItemTrowel.this.modelName, "inventory");
        }
    }
}

