package binnie.extrabees.genetics.effect;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IEffectData;
import forestry.core.render.ParticleRender;

import binnie.extrabees.ExtraBees;
import binnie.extrabees.genetics.ExtraBeesFlowers;
import binnie.extrabees.utils.Utils;

public enum ExtraBeesEffect implements IAlleleBeeEffect {
	ECTOPLASM,
	ACID,
	SPAWN_ZOMBIE,
	SPAWN_SKELETON,
	SPAWN_CREEPER,
	LIGHTNING,
	RADIOACTIVE,
	METEOR,
	HUNGER,
	FOOD,
	BLINDNESS,
	CONFUSION,
	FIREWORKS,
	FESTIVAL,
	BIRTHDAY,
	TELEPORT,
	GRAVITY,
	THIEF,
	WITHER,
	WATER,
	SLOW,
	BonemealSapling,
	BonemealFruit,
	BonemealMushroom,
	Power;

	private static final List<Birthday> birthdays = new ArrayList<>();

	static {
		birthdays.add(new Birthday(3, 10, "Binnie"));
	}

	private String fx;
	private boolean combinable;
	private boolean dominant;
	private int id;
	private String uid;

	ExtraBeesEffect() {
		this.fx = "";
		this.uid = this.toString().toLowerCase();
		this.combinable = false;
		this.dominant = true;
	}

	public static void doInit() {
		ExtraBeesEffect.BLINDNESS.setFX("blindness");
		ExtraBeesEffect.FOOD.setFX("food");
		ExtraBeesEffect.GRAVITY.setFX("gravity");
		ExtraBeesEffect.THIEF.setFX("gravity");
		ExtraBeesEffect.TELEPORT.setFX("gravity");
		ExtraBeesEffect.LIGHTNING.setFX("lightning");
		ExtraBeesEffect.METEOR.setFX("meteor");
		ExtraBeesEffect.RADIOACTIVE.setFX("radioactive");
		ExtraBeesEffect.WATER.setFX("water");
		ExtraBeesEffect.WITHER.setFX("wither");
		for (final ExtraBeesEffect effect : values()) {
			effect.register();
		}
	}

	public static void doAcid(final World world, final BlockPos pos) {
		final IBlockState blockState = world.func_180495_p(pos);
		final Block block = blockState.func_177230_c();
		if (block == Blocks.field_150347_e || block == Blocks.field_150348_b) {
			world.func_175656_a(pos, Blocks.field_150351_n.func_176223_P());
		} else if (block == Blocks.field_150346_d | block == Blocks.field_150349_c) {
			world.func_175656_a(pos, Blocks.field_150354_m.func_176223_P());
		}
	}

	public static int wearsItems(final EntityPlayer player) {
		return BeeManager.armorApiaristHelper.wearsItems(player, "", false);
	}

	public void register() {
		AlleleManager.alleleRegistry.registerAllele(this);
	}

	@Override
	public boolean isCombinable() {
		return this.combinable;
	}

	@Override
	public IEffectData validateStorage(final IEffectData storedData) {
		return storedData;
	}

	@Override
	public String getName() {
		return I18n.func_74838_a("effect." + this.name().toLowerCase() + ".name");
	}

	@Override
	public boolean isDominant() {
		return this.dominant;
	}

	public void spawnMob(final World world, final BlockPos pos, final ResourceLocation name) {
		if (this.anyPlayerInRange(world, pos, 16)) {
			final double var1 = pos.func_177958_n() + world.field_73012_v.nextFloat();
			final double var2 = pos.func_177956_o() + world.field_73012_v.nextFloat();
			final double var3 = pos.func_177952_p() + world.field_73012_v.nextFloat();
			world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, var1, var2, var3, 0.0, 0.0, 0.0);
			world.func_175688_a(EnumParticleTypes.FLAME, var1, var2, var3, 0.0, 0.0, 0.0);
			final EntityLiving entity = (EntityLiving) EntityList.func_188429_b(name, world);
			if (entity != null) {
				final int nearbyEntityCount = world.func_72872_a(entity.getClass(), new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)).func_72314_b(8.0, 4.0, 8.0)).size();
				if (nearbyEntityCount < 6) {
					final double var6 = pos.func_177958_n() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * 4.0;
					final double var7 = pos.func_177956_o() + world.field_73012_v.nextInt(3) - 1;
					final double var8 = pos.func_177952_p() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * 4.0;
					entity.func_70012_b(var6, var7, var8, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
					if (entity.func_70601_bi()) {
						world.func_72838_d(entity);
						world.func_175718_b(2004, pos, 0);//playSFX
						entity.func_70656_aK();
					}
				}
			}
		}
	}

	private boolean anyPlayerInRange(final World world, final BlockPos pos, final int distance) {
		return world.func_184137_a(pos.func_177958_n() + 0.5, pos.func_177956_o() + 0.5, pos.func_177952_p() + 0.5, distance, false) != null;
	}

	@Override
	public String getUID() {
		return "extrabees.effect." + this.uid;
	}

	@Override
	public IEffectData doEffect(final IBeeGenome genome, final IEffectData storedData, final IBeeHousing housing) {
		final World world = housing.getWorldObj();
		final int xHouse = housing.getCoordinates().func_177958_n();
		final int yHouse = housing.getCoordinates().func_177956_o();
		final int zHouse = housing.getCoordinates().func_177952_p();
		final Vec3i area = this.getModifiedArea(genome, housing);
		final int xd = 1 + area.func_177958_n() / 2;
		final int yd = 1 + area.func_177956_o() / 2;
		final int zd = 1 + area.func_177952_p() / 2;
		final int x1 = xHouse - xd + world.field_73012_v.nextInt(2 * xd + 1);
		int y1 = yHouse - yd + world.field_73012_v.nextInt(2 * yd + 1);
		final int z1 = zHouse - zd + world.field_73012_v.nextInt(2 * zd + 1);
		final BlockPos pos = new BlockPos(x1, y1, z1);
		switch (this) {
			case ECTOPLASM: {
				if (world.field_73012_v.nextInt(100) < 4) {
					if (world.func_175623_d(pos) && (world.func_175677_d(pos.func_177977_b(), false) || world.func_180495_p(pos.func_177977_b()).func_177230_c() == ExtraBees.ectoplasm)) {
						world.func_175656_a(pos, ExtraBees.ectoplasm.func_176223_P());
					}
					return storedData;
				}
				break;
			}
			case ACID: {
				if (world.field_73012_v.nextInt(100) < 6) {
					doAcid(world, pos);
					break;
				}
				break;
			}
			case SPAWN_ZOMBIE: {
				if (world.field_73012_v.nextInt(200) < 2) {
					this.spawnMob(world, pos, new ResourceLocation("zombie"));
					break;
				}
				break;
			}
			case SPAWN_SKELETON: {
				if (world.field_73012_v.nextInt(200) < 2) {
					this.spawnMob(world, pos, new ResourceLocation("skeleton"));
					break;
				}
				break;
			}
			case SPAWN_CREEPER: {
				if (world.field_73012_v.nextInt(200) < 2) {
					this.spawnMob(world, pos, new ResourceLocation("creeper"));
					break;
				}
				break;
			}
			case LIGHTNING: {
				if (world.field_73012_v.nextInt(100) < 1 && world.func_175710_j(pos) && world instanceof WorldServer) {
					world.func_72942_c(new EntityBeeLightning(world, x1, y1, z1));
					break;
				}
				break;
			}
			case METEOR: {
				if (world.field_73012_v.nextInt(100) < 1 && world.func_175710_j(pos)) {
					world.func_72838_d(new EntitySmallFireball(world, x1, y1 + 64, z1, 0.0, -0.6, 0.0));
					break;
				}
				break;
			}
			case RADIOACTIVE: {
				for (final EntityLivingBase entity : this.getEntities(EntityLivingBase.class, genome, housing)) {
					int damage = 4;
					if (entity instanceof EntityPlayer) {
						final int count = wearsItems((EntityPlayer) entity);
						if (count > 3) {
							continue;
						}
						if (count > 2) {
							damage = 1;
						} else if (count > 1) {
							damage = 2;
						} else if (count > 0) {
							damage = 3;
						}
					}
					entity.func_70097_a(DamageSource.field_76377_j, damage);
				}
				break;
			}
			case FOOD: {
				for (final EntityLivingBase entity : this.getEntities(EntityLivingBase.class, genome, housing)) {
					if (entity instanceof EntityPlayer) {
						final EntityPlayer player = (EntityPlayer) entity;
						player.func_71024_bL().func_75122_a(2, 0.2f);
					}
				}
				break;
			}
			case HUNGER: {
				for (final EntityLivingBase entity : this.getEntities(EntityLivingBase.class, genome, housing)) {
					if (entity instanceof EntityPlayer) {
						final EntityPlayer player = (EntityPlayer) entity;
						if (world.field_73012_v.nextInt(4) < wearsItems(player)) {
							continue;
						}
						player.func_71024_bL().func_75113_a(4.0f);
						player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 100));
					}
				}
				break;
			}
			case BLINDNESS: {
				for (final EntityLivingBase entity : this.getEntities(EntityLivingBase.class, genome, housing)) {
					if (entity instanceof EntityPlayer) {
						final EntityPlayer player = (EntityPlayer) entity;
						if (world.field_73012_v.nextInt(4) < wearsItems(player)) {
							continue;
						}
						player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 200));
					}
				}
				break;
			}
			case SLOW: {
				for (final EntityLivingBase entity : this.getEntities(EntityLivingBase.class, genome, housing)) {
					if (entity instanceof EntityPlayer) {
						final EntityPlayer player = (EntityPlayer) entity;
						if (world.field_73012_v.nextInt(4) < wearsItems(player)) {
							continue;
						}
						player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 200));
					}
				}
				break;
			}
			case CONFUSION: {
				for (final EntityLivingBase entity : this.getEntities(EntityLivingBase.class, genome, housing)) {
					if (entity instanceof EntityPlayer) {
						final EntityPlayer player = (EntityPlayer) entity;
						if (world.field_73012_v.nextInt(4) < wearsItems(player)) {
							continue;
						}
						player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200));
					}
				}
				break;
			}
			case BIRTHDAY:
			case FESTIVAL:
			case FIREWORKS: {
				if (world.field_73012_v.nextInt((this == ExtraBeesEffect.FIREWORKS) ? 8 : 12) < 1) {
					final FireworkCreator.Firework firework = new FireworkCreator.Firework();
					switch (this) {
						case BIRTHDAY: {
							firework.setShape(FireworkCreator.Shape.Star);
							firework.addColor(16768256);
							for (final Birthday birthday : ExtraBeesEffect.birthdays) {
								if (birthday.isToday()) {
									firework.addColor(16711680);
									firework.addColor(65280);
									firework.addColor(255);
									firework.setTrail();
									break;
								}
							}
						}
						case FIREWORKS: {
							firework.setShape(FireworkCreator.Shape.Ball);
							firework.addColor(genome.getPrimary().getSpriteColour(0));
							firework.addColor(genome.getPrimary().getSpriteColour(0));
							firework.addColor(genome.getPrimary().getSpriteColour(1));
							firework.addColor(genome.getSecondary().getSpriteColour(0));
							firework.addColor(genome.getSecondary().getSpriteColour(0));
							firework.addColor(genome.getPrimary().getSpriteColour(1));
							firework.setTrail();
							break;
						}
					}
					final EntityFireworkRocket var11 = new EntityFireworkRocket(world, x1, y1, z1, firework.getFirework());
					if (world.func_175710_j(pos)) {
						world.func_72838_d(var11);
					}
					break;
				}
				break;
			}
			case GRAVITY: {
				final List<Entity> entities2 = this.getEntities(Entity.class, genome, housing);
				for (final Entity entity2 : entities2) {
					float entityStrength = 1.0f;
					if (entity2 instanceof EntityPlayer) {
						entityStrength *= 100.0f;
					}
					final double dx = x1 - entity2.field_70165_t;
					final double dy = y1 - entity2.field_70163_u;
					final double dz = z1 - entity2.field_70161_v;
					if (dx * dx + dy * dy + dz * dz < 2.0) {
						return storedData;
					}
					final double strength = 0.5 / (dx * dx + dy * dy + dz * dz) * entityStrength;
					entity2.func_70024_g(dx * strength, dy * strength, dz * strength);
				}
				break;
			}
			case THIEF: {
				final List<EntityPlayer> entities3 = this.getEntities(EntityPlayer.class, genome, housing);
				for (final EntityPlayer entity3 : entities3) {
					final double dx = x1 - entity3.field_70165_t;
					final double dy = y1 - entity3.field_70163_u;
					final double dz = z1 - entity3.field_70161_v;
					if (dx * dx + dy * dy + dz * dz < 2.0) {
						return storedData;
					}
					final double strength = 0.5 / (dx * dx + dy * dy + dz * dz);
					entity3.func_70024_g(-dx * strength, -dy * strength, -dz * strength);
				}
				break;
			}
			case TELEPORT: {
				if (world.field_73012_v.nextInt(80) > 1) {
					return storedData;
				}
				final List<Entity> entities4 = this.getEntities(Entity.class, genome, housing);
				if (entities4.size() == 0) {
					return storedData;
				}
				final Entity entity4 = entities4.get(world.field_73012_v.nextInt(entities4.size()));
				if (!(entity4 instanceof EntityLiving)) {
					return storedData;
				}
				final float jumpDist = 5.0f;
				if (y1 < 4) {
					y1 = 4;
				}
				if (!world.func_175623_d(pos) || !world.func_175623_d(pos.func_177984_a())) {
					return storedData;
				}
				entity4.func_70634_a(x1, y1, z1);
				((EntityLiving) entity4).func_70690_d(new PotionEffect(MobEffects.field_76431_k, 160, 10));
				break;
			}
			case WATER: {
				if (world.field_73012_v.nextInt(120) > 1) {
					return storedData;
				}
				IFluidHandler fluidHandler = Utils.getCapability(world, pos, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP);
				if (fluidHandler != null) {
					fluidHandler.fill(new FluidStack(FluidRegistry.WATER, 100), true);
					break;
				}
				break;
			}
			case BonemealSapling: {
				if (world.field_73012_v.nextInt(20) > 1) {
					return storedData;
				}
				if (ExtraBeesFlowers.Sapling.isAcceptedFlower(world, pos)) {
					ItemDye.func_179234_a(new ItemStack(Blocks.field_150346_d, 1), world, pos);
					break;
				}
				break;
			}
			case BonemealFruit: {
				if (world.field_73012_v.nextInt(20) > 1) {
					return storedData;
				}
				if (ExtraBeesFlowers.Fruit.isAcceptedFlower(world, pos)) {
					ItemDye.func_179234_a(new ItemStack(Blocks.field_150346_d, 1), world, pos);
					break;
				}
				break;
			}
			case BonemealMushroom: {
				if (world.field_73012_v.nextInt(20) > 1) {
					return storedData;
				}
				if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150338_P || world.func_180495_p(pos).func_177230_c() == Blocks.field_150337_Q) {
					ItemDye.func_179234_a(new ItemStack(Blocks.field_150346_d, 1), world, pos);
					break;
				}
				break;
			}
			case Power: {
				final TileEntity tile2 = world.func_175625_s(pos);
				if (tile2.hasCapability(CapabilityEnergy.ENERGY, EnumFacing.UP)) {
					IEnergyStorage storage = tile2.getCapability(CapabilityEnergy.ENERGY, EnumFacing.UP);
					storage.receiveEnergy(5, false);
				}
				break;
			}
		}
		return storedData;
	}

	protected Vec3i getModifiedArea(final IBeeGenome genome, final IBeeHousing housing) {
		Vec3i territory = genome.getTerritory();
		territory = new Vec3i(
			territory.func_177958_n() * (int) (BeeManager.beeRoot.createBeeHousingModifier(housing).getTerritoryModifier(genome, 1.0f) * 3.0f),
			territory.func_177956_o() * (int) (BeeManager.beeRoot.createBeeHousingModifier(housing).getTerritoryModifier(genome, 1.0f) * 3.0f),
			territory.func_177952_p() * (int) (BeeManager.beeRoot.createBeeHousingModifier(housing).getTerritoryModifier(genome, 1.0f) * 3.0f)
		);
		if (territory.func_177958_n() < 1) {
			territory = new Vec3i(1, territory.func_177956_o(), territory.func_177952_p());
		}
		if (territory.func_177956_o() < 1) {
			territory = new Vec3i(territory.func_177958_n(), 1, territory.func_177952_p());
		}
		if (territory.func_177952_p() < 1) {
			territory = new Vec3i(territory.func_177958_n(), territory.func_177956_o(), 1);
		}
		return territory;
	}

	@Override
	@SideOnly(Side.CLIENT)
	public IEffectData doFX(final IBeeGenome genome, final IEffectData storedData, final IBeeHousing housing) {
		IBeekeepingLogic beekeepingLogic = housing.getBeekeepingLogic();
		List<BlockPos> flowerPositions = beekeepingLogic.getFlowerPositions();
		ParticleRender.addBeeHiveFX(housing, genome, flowerPositions);
		return storedData;
	}

	public String getFX() {
		return this.fx;
	}

	private void setFX(final String string) {
		this.fx = "particles/" + string;
	}

	public <T extends Entity> List<T> getEntities(final Class<T> eClass, final IBeeGenome genome, final IBeeHousing housing) {
		final Vec3i area = genome.getTerritory();
		final int[] offset = {-Math.round(area.func_177958_n() / 2), -Math.round(area.func_177956_o() / 2), -Math.round(area.func_177952_p() / 2)};
		final int[] min = {housing.getCoordinates().func_177958_n() + offset[0], housing.getCoordinates().func_177956_o() + offset[1], housing.getCoordinates().func_177952_p() + offset[2]};
		final int[] max = {housing.getCoordinates().func_177958_n() + offset[0] + area.func_177958_n(), housing.getCoordinates().func_177956_o() + offset[1] + area.func_177956_o(), housing.getCoordinates().func_177952_p() + offset[2] + area.func_177952_p()};
		final AxisAlignedBB box = new AxisAlignedBB(min[0], min[1], min[2], max[0], max[1], max[2]);
		return housing.getWorldObj().func_72872_a(eClass, box);
	}

	@Override
	public String getUnlocalizedName() {
		return this.getUID();
	}

	public static class Birthday {

		private final int month;
		private final int date;
		private final String name;

		private Birthday(final int month, final int date, final String name) {
			this.month = month;
			this.date = date + 1;
			this.name = name;
		}

		public boolean isToday() {
			return Calendar.getInstance().get(Calendar.DATE) == this.date && Calendar.getInstance().get(Calendar.MONTH) == this.month;
		}

		public String getName() {
			return this.name;
		}
	}
}
