package binnie.extrabees.genetics;

import java.util.Collections;
import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import net.minecraftforge.common.EnumPlantType;

import forestry.api.apiculture.FlowerManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.ICheckPollinatable;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IFruitBearer;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;

import binnie.core.util.I18N;
import binnie.extrabees.utils.Utils;

public enum ExtraBeesFlowers implements IFlowerProvider, IAlleleFlowers, IChromosomeType {
	WATER,
	SUGAR,
	ROCK,
	BOOK,
	DEAD,
	REDSTONE,
	WOOD,
	LEAVES,
	Sapling,
	Fruit,
	Mystical;

	boolean dominant;

	ExtraBeesFlowers() {
		this.dominant = true;
	}

	public static void doInit() {
		for (final ExtraBeesFlowers effect : values()) {
			effect.register();
		}
	}

	@Override
	public String getUID() {
		return "extrabees.flower." + this.toString().toLowerCase();
	}

	@Override
	public boolean isDominant() {
		return this.dominant;
	}

	@Override
	public IFlowerProvider getProvider() {
		return this;
	}

	@Override
	public String getDescription() {
		return I18N.localise("extrabees.flowers." + this.name().toLowerCase() + ".name");
	}

	public void register() {
		//AlleleManager.alleleRegistry.registerAllele(this);

		for (Block block : getAcceptableBlocks()) {
			FlowerManager.flowerRegistry.registerAcceptableFlower(block, getUID());
		}

		AlleleManager.alleleRegistry.registerAllele(this, this);
	}

	public List<Block> getAcceptableBlocks() {
		switch (this) {
			case WATER: {
				return Collections.singletonList(Blocks.field_150392_bi);
			}
			case SUGAR: {
				return Collections.singletonList(Blocks.field_150436_aH);
			}
			case ROCK: {
				return Collections.singletonList(Blocks.field_150347_e);
			}
			case BOOK: {
				return Collections.singletonList(Blocks.field_150342_X);
			}
			case REDSTONE: {
				return Collections.singletonList(Blocks.field_150429_aA);
			}
			case DEAD: {
				return Collections.singletonList(Blocks.field_150330_I);
			}
			case Fruit: {
				return Collections.emptyList(); // TODO: what is this supposed to be? It was Items.APPLE before.
			}
			case LEAVES: {
				return Collections.singletonList(Blocks.field_150362_t);
			}
			case Sapling: {
				return Collections.singletonList(Blocks.field_150345_g);
			}
			case WOOD: {
				return Collections.singletonList(Blocks.field_150364_r);
			}
			default: {
				return Collections.emptyList();
			}
		}
	}

	public boolean isAcceptedFlower(final World world, final BlockPos pos) {
		final Block block = world.func_180495_p(pos).func_177230_c();
		switch (this) {
			case WATER: {
				return block == Blocks.field_150392_bi;
			}
			case ROCK: {
				return world.func_180495_p(pos).func_185904_a() == Material.field_151576_e;
			}
			case SUGAR: {
				return block == Blocks.field_150436_aH;
			}
			case BOOK: {
				return block == Blocks.field_150342_X;
			}
			case REDSTONE: {
				return block == Blocks.field_150429_aA;
			}
			case DEAD: {
				return block == Blocks.field_150330_I;
			}
			case WOOD: {
				return block.isWood(world, pos);
			}
			case Fruit: {
				return world.func_175625_s(pos) instanceof IFruitBearer;
			}
			case LEAVES: {
				return block.isLeaves(world.func_180495_p(pos), world, pos);
			}
			case Sapling: {
				return block.getClass().getName().toLowerCase().contains("sapling");
			}
			case Mystical: {
				return block == Utils.getBotaniaBlock("flower");
			}
			default: {
				return false;
			}
		}
	}

	/*@Override
	public boolean growFlower(final World world, final IIndividual individual, final BlockPos pos) {
		switch (this) {
		case WATER: {
			return world.isAirBlock(x, y, z) && world.getBlock(x, y - 1, z) == Blocks.water && world.setBlock(x, y, z, Blocks.waterlily, 0, 2);
		}
		case SUGAR: {
			return world.getBlock(x, y - 1, z) == Blocks.reeds && world.isAirBlock(x, y, z) && world.setBlock(x, y, z, Blocks.reeds, 0, 0);
		}
		default: {
			return false;
		}
		}
	}*/

	@Override
	public String getName() {
		return this.getDescription();
	}

	@Override
	public String getUnlocalizedName() {
		return this.getUID();
	}

	@Override
	public String getFlowerType() {
		return this.getUID();
	}

	/*@Override
	public Set<IFlower> getFlowers() {
		return new HashSet<IFlower>();
	}*/

	@Override
	public Class<? extends IAllele> getAlleleClass() {
		return getClass();
	}

	@Override
	public ISpeciesRoot getSpeciesRoot() {
		return AlleleManager.alleleRegistry.getSpeciesRoot(getUID());
	}

	@Override
	public boolean isAcceptedPollinatable(World world, ICheckPollinatable pollinatable) {
		return pollinatable.getPlantType() != EnumPlantType.Nether;
	}

	@Override
	public NonNullList<ItemStack> affectProducts(World world, IIndividual individual, BlockPos pos, NonNullList<ItemStack> products) {
		if (this == ExtraBeesFlowers.Mystical) {
			final NonNullList<ItemStack> prods = NonNullList.func_191196_a();
			prods.addAll(products);
			for (int k = 0; k < 50; ++k) {
				final int tX = 7;
				final int tY = 7;
				final int tZ = 3;
				final int x2 = pos.func_177958_n() - tX + world.field_73012_v.nextInt(1 + 2 * tX);
				final int y2 = pos.func_177956_o() - tY + world.field_73012_v.nextInt(1 + 2 * tY);
				final int z2 = pos.func_177952_p() - tZ + world.field_73012_v.nextInt(1 + 2 * tZ);
				final BlockPos pos2 = new BlockPos(x2, y2, z2);
				final Block block = world.func_180495_p(pos2).func_177230_c();
				if (block == Utils.getBotaniaBlock("flower")) {
					final int meta = world.func_180495_p(pos2).func_177230_c().func_176201_c(world.func_180495_p(pos2));
					final Item item = Utils.getBotaniaItem("petal");
					if (item != null) {
						prods.add(new ItemStack(item, 1, meta));
					}
				}
			}
			return prods;
		}
		return products;
	}
}
